/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import java.nio.ByteBuffer;

public class JPXReader {
    private final ByteBuffer buffer;

    public JPXReader(byte[] byArray) {
        this.buffer = ByteBuffer.wrap(byArray);
    }

    public int getLimit() {
        return this.buffer.limit();
    }

    public byte readByte() {
        return this.buffer.get();
    }

    public byte readByte(int n) {
        return this.buffer.get(n);
    }

    public int readUByte() {
        return this.buffer.get() & 0xFF;
    }

    public byte[] readBytes(int n) {
        byte[] byArray = new byte[n];
        this.buffer.get(byArray);
        return byArray;
    }

    public byte[] readBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        this.buffer.get(byArray, n, n2);
        return byArray;
    }

    public int readUnsignedByte(int n) {
        return this.buffer.get(n) & 0xFF;
    }

    public int readUShort() {
        return this.buffer.getShort() & 0xFFFF;
    }

    public int readUShort(int n) {
        return this.buffer.getShort(n) & 0xFFFF;
    }

    public short readShort() {
        return this.buffer.getShort();
    }

    public short readShort(int n) {
        return this.buffer.getShort(n);
    }

    public int readInt() {
        return this.buffer.getInt();
    }

    public int readInt(int n) {
        return this.buffer.getInt(n);
    }

    public int getPosition() {
        return this.buffer.position();
    }

    public long readLong() {
        return this.buffer.getLong();
    }

    public long readLong(int n) {
        return this.buffer.getLong(n);
    }

    public void setPosition(int n) {
        this.buffer.position(n);
    }

    public int getRemaining() {
        return this.buffer.remaining();
    }
}

