/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.scale;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.util.BitSet;

public class QualityScaler {
    private static final float PI_FLOAT = (float)Math.PI;

    public static BufferedImage getScaledImage(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        ColorModel colorModel = bufferedImage.getColorModel();
        int n5 = colorModel.getNumComponents();
        if (n == n3 && n2 == n4) {
            return bufferedImage;
        }
        if (colorModel instanceof IndexColorModel || bufferedImage.getType() == 0) {
            return QualityScaler.getCubicScaled(bufferedImage, n, n2);
        }
        int[] nArray = QualityScaler.getPixels(bufferedImage);
        int[] nArray2 = new int[n * n2];
        QualityScaler.doFilter(nArray, nArray2, n3, n4, n, n2, n5);
        return QualityScaler.getImageFromPixels(nArray2, n, n2, bufferedImage.getType());
    }

    private static BufferedImage getCubicScaled(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        double d = (double)n / (double)n3;
        double d2 = (double)n2 / (double)n4;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 3);
        return affineTransformOp.filter(bufferedImage, new BufferedImage(n, n2, bufferedImage.getType()));
    }

    private static void doFilter(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5) {
        int n6;
        WeightBox weightBox = QualityScaler.generateWeightBox(n, n3);
        WeightBox weightBox2 = QualityScaler.generateWeightBox(n2, n4);
        int n7 = (int)Math.ceil(weightBox2.width) * 2;
        byte[][] byArrayArray = new byte[n2][];
        for (n6 = 0; n6 < n7 && n6 < n2; ++n6) {
            byArrayArray[n6] = new byte[n3 * n5];
        }
        for (n6 = n7; n6 < byArrayArray.length; ++n6) {
            byArrayArray[n6] = byArrayArray[n6 % n7];
        }
        byte[][] byArrayArray2 = byArrayArray;
        QualityScaler.doScaling(nArray, byArrayArray2, nArray2, n, n2, n3, n4, n5, weightBox, weightBox2);
    }

    private static WeightBox generateWeightBox(int n, int n2) {
        int[] nArray;
        float[] fArray;
        int n3;
        float f;
        float f2 = (float)n2 / (float)n;
        int[] nArray2 = new int[n2];
        if (f2 < 1.0f) {
            f = 3.0f / f2;
            n3 = (int)(f * 2.0f + 2.0f);
            fArray = new float[n2 * n3];
            nArray = new int[n2 * n3];
            float f3 = (float)(1.0 / (Math.ceil(f) / 3.0));
            for (int i = 0; i < n2; ++i) {
                int n4;
                float f4;
                int n5;
                int n6 = i * n3;
                float f5 = (float)i / f2;
                int n7 = (int)Math.floor(f5 - f);
                int n8 = (int)Math.ceil(f5 + f);
                for (n5 = n7; n5 <= n8; ++n5) {
                    f4 = QualityScaler.apply((f5 - (float)n5) * f3);
                    if (f4 == 0.0f) continue;
                    n4 = n5 < 0 ? -n5 : (n5 >= n ? n - n5 + n - 1 : n5);
                    int n9 = nArray2[i];
                    int n10 = i;
                    nArray2[n10] = nArray2[n10] + 1;
                    if (n4 < 0 || n4 >= n) {
                        f4 = 0.0f;
                    }
                    nArray[n6 + n9] = n4;
                    fArray[n6 + n9] = f4;
                }
                n5 = nArray2[i];
                f4 = 0.0f;
                for (n4 = 0; n4 < n5; ++n4) {
                    f4 += fArray[n6 + n4];
                }
                if (f4 == 0.0f) continue;
                for (n4 = 0; n4 < n5; ++n4) {
                    int n11 = n6 + n4;
                    fArray[n11] = fArray[n11] / f4;
                }
            }
        } else {
            f = 3.0f;
            n3 = 7;
            fArray = new float[n2 * n3];
            nArray = new int[n2 * n3];
            for (int i = 0; i < n2; ++i) {
                int n12;
                float f6;
                int n13;
                int n14 = i * n3;
                float f7 = (float)i / f2;
                int n15 = (int)Math.floor(f7 - 3.0f);
                int n16 = (int)Math.ceil(f7 + 3.0f);
                for (n13 = n15; n13 <= n16; ++n13) {
                    f6 = QualityScaler.apply(f7 - (float)n13);
                    if (f6 == 0.0f) continue;
                    n12 = n13 < 0 ? -n13 : (n13 >= n ? n - n13 + n - 1 : n13);
                    int n17 = nArray2[i];
                    int n18 = i;
                    nArray2[n18] = nArray2[n18] + 1;
                    if (n12 < 0 || n12 >= n) {
                        f6 = 0.0f;
                    }
                    nArray[n14 + n17] = n12;
                    fArray[n14 + n17] = f6;
                }
                n13 = nArray2[i];
                f6 = 0.0f;
                for (n12 = 0; n12 < n13; ++n12) {
                    f6 += fArray[n14 + n12];
                }
                if (f6 == 0.0f) continue;
                for (n12 = 0; n12 < n13; ++n12) {
                    int n19 = n14 + n12;
                    fArray[n19] = fArray[n19] / f6;
                }
            }
        }
        return new WeightBox(nArray2, nArray, fArray, n3, f);
    }

    private static void doScaling(int[] nArray, byte[][] byArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, WeightBox weightBox, WeightBox weightBox2) {
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        byte[] byArray2 = new byte[n3 * n5];
        BitSet bitSet = new BitSet(n2);
        for (int i = n4 - 1; i >= 0; --i) {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11 = i * weightBox2.numContributors;
            int n12 = weightBox2.ns[i];
            int n13 = n11;
            for (n10 = n12 - 1; n10 >= 0; --n10) {
                n9 = weightBox2.pixels[n13++];
                if (bitSet.get(n9)) continue;
                bitSet.set(n9);
                QualityScaler.getPixelsBGR(nArray, n9, n, nArray4);
                for (n8 = 0; n8 < n5; ++n8) {
                    QualityScaler.getHorizontalComps(nArray4, n8, nArray3, n5);
                    for (int j = n3 - 1; j >= 0; --j) {
                        n7 = j * n5;
                        n6 = weightBox.ns[j];
                        float f = 0.0f;
                        int n14 = j * weightBox.numContributors;
                        for (int k = n6 - 1; k >= 0; --k) {
                            f += (float)nArray3[weightBox.pixels[n14]] * weightBox.weights[n14];
                            ++n14;
                        }
                        QualityScaler.clamp(byArray[n9], n8, (int)f, n7);
                    }
                }
            }
            for (n13 = 0; n13 < n3; ++n13) {
                n10 = n13 * n5;
                n9 = n13 * n5;
                for (n8 = n5 - 1; n8 >= 0; --n8) {
                    float f = 0.0f;
                    n7 = n11;
                    for (n6 = n12 - 1; n6 >= 0; --n6) {
                        int n15 = weightBox2.pixels[n7];
                        f += (float)(byArray[n15][n10 + n8] & 0xFF) * weightBox2.weights[n7];
                        ++n7;
                    }
                    QualityScaler.clamp(byArray2, n8, f, n9);
                }
            }
            QualityScaler.setBGRPixels(byArray2, nArray2, i, n3, n5);
        }
    }

    private static void clamp(byte[] byArray, int n, float f, int n2) {
        byArray[n2 + n] = (byte)(f < 0.0f ? 0 : (byte)(f > 255.0f ? -1 : (byte)f));
    }

    private static void getHorizontalComps(int[] nArray, int n, int[] nArray2, int n2) {
        int n3 = 8 * (n2 - n - 1);
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[i] >> n3 & 0xFF;
        }
    }

    private static void getPixelsBGR(int[] nArray, int n, int n2, int[] nArray2) {
        int n3 = n * n2;
        System.arraycopy(nArray, n3, nArray2, 0, n2);
    }

    private static void setBGRPixels(byte[] byArray, int[] nArray, int n, int n2, int n3) {
        int n4 = n * n2;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6 = 0;
            for (int j = 0; j < n3; ++j) {
                n6 |= (byArray[n5++] & 0xFF) << 8 * (n3 - j - 1);
            }
            nArray[n4 + i] = n6;
        }
    }

    private static int[] getPixels(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = n * n2;
        int[] nArray = new int[n3];
        int n4 = 0;
        switch (bufferedImage.getType()) {
            case 10: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = byArray[i] & 0xFF;
                }
                break;
            }
            case 5: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n3; ++i) {
                    int n5 = byArray[n4++] & 0xFF;
                    int n6 = byArray[n4++] & 0xFF;
                    int n7 = byArray[n4++] & 0xFF;
                    nArray[i] = n7 << 16 | n6 << 8 | n5;
                }
                break;
            }
            case 6: 
            case 7: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n3; ++i) {
                    int n8 = byArray[n4++] & 0xFF;
                    int n9 = byArray[n4++] & 0xFF;
                    int n10 = byArray[n4++] & 0xFF;
                    int n11 = byArray[n4++] & 0xFF;
                    nArray[i] = n8 << 24 | n11 << 16 | n10 << 8 | n9;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            }
        }
        return nArray;
    }

    private static float apply(float f) {
        if (f == 0.0f) {
            return 1.0f;
        }
        if (f < 0.0f) {
            f = -f;
        }
        if (f < 3.0f) {
            return (float)(QualityScaler.sincIt(f *= (float)Math.PI) * QualityScaler.sincIt(f / 3.0f));
        }
        return 0.0f;
    }

    private static BufferedImage getImageFromPixels(int[] nArray, int n, int n2, int n3) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        int n4 = n * n2;
        int n5 = 0;
        switch (n3) {
            case 10: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n4; ++i) {
                    byArray[i] = (byte)nArray[i];
                }
                break;
            }
            case 5: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n4; ++i) {
                    int n6 = nArray[i];
                    byArray[n5++] = (byte)(n6 & 0xFF);
                    byArray[n5++] = (byte)(n6 >> 8 & 0xFF);
                    byArray[n5++] = (byte)(n6 >> 16);
                }
                break;
            }
            case 6: 
            case 7: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n4; ++i) {
                    int n7 = nArray[i];
                    byArray[n5++] = (byte)(n7 >> 24);
                    byArray[n5++] = (byte)(n7 & 0xFF);
                    byArray[n5++] = (byte)(n7 >> 8 & 0xFF);
                    byArray[n5++] = (byte)(n7 >> 16 & 0xFF);
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                int[] nArray2 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                System.arraycopy(nArray, 0, nArray2, 0, n4);
            }
        }
        return bufferedImage;
    }

    private static double sincIt(float f) {
        return Math.sin(f) / (double)f;
    }

    private static class WeightBox {
        private final int[] ns;
        private final int[] pixels;
        private final float[] weights;
        private final int numContributors;
        private final float width;

        private WeightBox(int[] nArray, int[] nArray2, float[] fArray, int n, float f) {
            this.ns = nArray;
            this.pixels = nArray2;
            this.weights = fArray;
            this.numContributors = n;
            this.width = f;
        }
    }
}

