/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

public class LZW {
    private byte[][] codes;
    private byte[] input;
    private byte[] output;
    private int bitsToGet = 9;
    private int bp;
    private int tp;
    private int op;
    private int putBuffer;
    private int putBits;

    public void decompress(byte[] byArray, byte[] byArray2) {
        int n;
        this.init();
        this.input = byArray2;
        this.output = byArray;
        this.bp = 0;
        this.op = 0;
        this.putBuffer = 0;
        this.putBits = 0;
        int n2 = 0;
        while ((n = this.findNext()) != 257 && this.op < byArray.length) {
            byte[] byArray3;
            if (n == 256) {
                this.init();
                n = this.findNext();
                if (n == 257) break;
                this.addCodes(this.codes[n]);
                n2 = n;
                continue;
            }
            if (n < this.tp) {
                byArray3 = this.codes[n];
                this.addCodes(byArray3);
                this.addCodeToCodes(this.codes[n2], byArray3[0]);
                n2 = n;
                continue;
            }
            byArray3 = this.codes[n2];
            byArray3 = LZW.generateCodeArray(byArray3, byArray3[0]);
            this.addCodes(byArray3);
            this.addCodeArrToCodes(byArray3);
            n2 = n;
        }
    }

    public void init() {
        this.codes = new byte[4096][];
        for (int i = 0; i < 256; ++i) {
            this.codes[i] = new byte[1];
            this.codes[i][0] = (byte)i;
        }
        this.tp = 258;
        this.bitsToGet = 9;
    }

    private void addCodes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.output[this.op++] = byArray[i];
        }
    }

    private void addCodeToCodes(byte[] byArray, byte by) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        this.codes[this.tp++] = byArray2;
        if (this.tp == 511) {
            this.bitsToGet = 10;
        } else if (this.tp == 1023) {
            this.bitsToGet = 11;
        } else if (this.tp == 2047) {
            this.bitsToGet = 12;
        }
    }

    private void addCodeArrToCodes(byte[] byArray) {
        this.codes[this.tp++] = byArray;
        if (this.tp == 511) {
            this.bitsToGet = 10;
        } else if (this.tp == 1023) {
            this.bitsToGet = 11;
        } else if (this.tp == 2047) {
            this.bitsToGet = 12;
        }
    }

    private static byte[] generateCodeArray(byte[] byArray, byte by) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        return byArray2;
    }

    private int findNext() {
        int[] nArray = new int[]{511, 1023, 2047, 4095};
        try {
            this.putBuffer = this.putBuffer << 8 | this.input[this.bp++] & 0xFF;
            this.putBits += 8;
            if (this.putBits < this.bitsToGet) {
                this.putBuffer = this.putBuffer << 8 | this.input[this.bp++] & 0xFF;
                this.putBits += 8;
            }
            int n = this.putBuffer >> this.putBits - this.bitsToGet & nArray[this.bitsToGet - 9];
            this.putBits -= this.bitsToGet;
            return n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("Exception in findNext " + arrayIndexOutOfBoundsException);
            return 257;
        }
    }
}

