/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webm;

import com.idrsolutions.image.webm.LittleReader;
import com.idrsolutions.image.webm.LookUp;
import java.io.IOException;

public class BitDecoder {
    private int bPos;
    LittleReader reader;
    private int offset;
    private int range;
    private int value;

    BitDecoder(LittleReader littleReader, int n) {
        this.reader = littleReader;
        this.offset = n;
        this.value = 0;
        this.reader.seek(this.offset);
        this.value = this.reader.getUINT8() << 8;
        ++this.offset;
        this.range = 255;
        this.bPos = 0;
    }

    int getBit() throws IOException {
        return this.getProbBit(128);
    }

    int getProbBit(int n) throws IOException {
        int n2 = 0;
        int n3 = this.value;
        int n4 = 1 + ((this.range - 1) * n >> 8);
        int n5 = n4 << 8;
        int n6 = n4;
        if (n3 >= n5) {
            n6 = this.range - n4;
            n3 -= n5;
            n2 = 1;
        }
        byte by = LookUp.BITS_NORM[n6];
        n6 <<= by;
        n3 <<= by;
        this.bPos -= by;
        if (this.bPos <= 0) {
            n3 |= this.reader.getUINT8() << -this.bPos;
            ++this.offset;
            this.bPos += 8;
        }
        this.value = n3;
        this.range = n6;
        return n2;
    }

    int getLiteral(int n) throws IOException {
        int n2 = 0;
        while (n-- > 0) {
            n2 = (n2 << 1) + this.getProbBit(128);
        }
        return n2;
    }

    int getTree(int[] nArray, int[] nArray2) throws IOException {
        int n = nArray[this.getProbBit(nArray2[0])];
        while (n > 0) {
            n = nArray[n + this.getProbBit(nArray2[n >> 1])];
        }
        return -n;
    }

    int skipTree(int[] nArray, int[] nArray2, int n) throws IOException {
        int n2 = n << 1;
        n2 = nArray[n2 + this.getProbBit(nArray2[n2 >> 1])];
        while (n2 > 0) {
            n2 = nArray[n2 + this.getProbBit(nArray2[n2 >> 1])];
        }
        return -n2;
    }

    void seek() throws IOException {
        this.reader.seek(this.offset);
    }
}

