/*
 * Decompiled with CFR 0.152.
 */
package SK.gnome.twain;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TwainImage
implements ImageConsumer,
ImageProducer {
    private int width;
    private int height;
    private int[][] intPixels;
    private byte[][] bytePixels;
    private ColorModel colorModel;
    private int hints;
    private ImageProducer producer;
    private Vector consumers = new Vector();

    public TwainImage(ImageProducer producer) {
        this.producer = producer;
        producer.startProduction(this);
    }

    public void imageComplete(int status) {
    }

    public void setColorModel(ColorModel colorModel) {
        this.colorModel = colorModel;
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setHints(int hints) {
        this.hints = hints;
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        if (this.bytePixels == null) {
            this.bytePixels = new byte[this.height][this.width];
        }
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                this.bytePixels[y + j][x + i] = pixels[off + j * scansize + i];
            }
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (this.intPixels == null) {
            this.intPixels = new int[this.height][this.width];
        }
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                this.intPixels[y + j][x + i] = pixels[off + j * scansize + i];
            }
        }
    }

    public void setProperties(Hashtable props) {
    }

    public void addConsumer(ImageConsumer consumer) {
        if (!this.consumers.contains(consumer)) {
            this.consumers.addElement(consumer);
        }
    }

    public boolean isConsumer(ImageConsumer consumer) {
        return this.consumers.contains(consumer);
    }

    public void removeConsumer(ImageConsumer consumer) {
        this.consumers.removeElement(consumer);
    }

    public void startProduction(ImageConsumer consumer) {
        this.addConsumer(consumer);
        Enumeration e = this.consumers.elements();
        while (e.hasMoreElements()) {
            ImageConsumer c = (ImageConsumer)e.nextElement();
            c.setDimensions(this.width, this.height);
            c.setHints(this.hints);
            c.setColorModel(this.colorModel);
            for (int j = 0; j < this.height; ++j) {
                if (this.bytePixels != null) {
                    c.setPixels(0, j, this.width, 1, this.colorModel, this.bytePixels[j], 0, this.width);
                    continue;
                }
                c.setPixels(0, j, this.width, 1, this.colorModel, this.intPixels[j], 0, this.width);
            }
            c.imageComplete(3);
        }
        this.removeConsumer(consumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer consumer) {
    }
}

