-- Temporary Table used for initial population of BLOB Column
CREATE TABLE LB_BLOB_DOCS
(
  DOC_SEQ_NO  NUMBER                            NOT NULL,
  BLOB_DOC    BLOB
)
/

CREATE UNIQUE INDEX LB_BLOB_DOCS_PK ON LB_BLOB_DOCS
(DOC_SEQ_NO)
/

CREATE SEQUENCE LB_BLOB_DOCS_SEQ
  START WITH 1
  MAXVALUE 9999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  NOCACHE
  ORDER
  NOKEEP
/ 

-- Actual D/B Transaction Table that records all pertinent details of captured document
CREATE TABLE LB_EIS_DB_DOCS
(
  DOC_ID    NUMBER                              NOT NULL,
  DOC_NAME  VARCHAR2(100 BYTE)                  NOT NULL,
  DOC_DATE  DATE                                NOT NULL,
  FORMAT    VARCHAR2(20 BYTE),
  BLOB_DOC  BLOB
)
/

CREATE UNIQUE INDEX LB_IMAGE_BLOB_DOCS_PK ON LB_EIS_DB_DOCS
(DOC_ID)
/

CREATE SEQUENCE LB_IMGBLOBDOC_SEQ
  START WITH 1
  MAXVALUE 9999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  NOCACHE
  ORDER
  NOKEEP
/
