/*
 * Decompiled with CFR 0.152.
 */
package SK.gnome.capabilities;

import SK.gnome.capabilities.Capabilities;
import SK.gnome.capabilities.Capability;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;

public class PreviewCanvas
extends JPanel
implements MouseMotionListener,
MouseListener,
ComponentListener,
PropertyChangeListener {
    private Image originalImage = null;
    private BufferedImage compositeImage;
    private BufferedImage image;
    private Rectangle p = new Rectangle();
    private Rectangle top = new Rectangle();
    private Rectangle bottom = new Rectangle();
    private Rectangle left = new Rectangle();
    private Rectangle right = new Rectangle();
    private Rectangle leftTop = new Rectangle();
    private Rectangle rightTop = new Rectangle();
    private Rectangle leftBottom = new Rectangle();
    private Rectangle rightBottom = new Rectangle();
    private Point firstClick;
    private Rectangle firstLocation = new Rectangle();
    static final int DRAG_MODE_IN = 0;
    static final int DRAG_MODE_HORIZONTAL = 1;
    static final int DRAG_MODE_VERTICAL = 2;
    static final int DRAG_MODE_CORNER = 3;
    private int dragMode = 0;
    static final int BORDER = 10;
    static final int CORNER = 15;
    private int originalImageWidth;
    private int originalImageHeight;
    private int imageWidth;
    private int imageHeight;
    private Capability tl_xCapability;
    private Capability tl_yCapability;
    private Capability br_xCapability;
    private Capability br_yCapability;
    private boolean composite;

    public PreviewCanvas(Capability tl_xCapability, Capability tl_yCapability, Capability br_xCapability, Capability br_yCapability) {
        this.tl_xCapability = tl_xCapability;
        this.tl_yCapability = tl_yCapability;
        this.br_xCapability = br_xCapability;
        this.br_yCapability = br_yCapability;
        if (null != tl_xCapability) {
            tl_xCapability.addListener(this);
        }
        if (null != tl_yCapability) {
            tl_yCapability.addListener(this);
        }
        if (null != br_xCapability) {
            br_xCapability.addListener(this);
        }
        if (null != br_yCapability) {
            br_yCapability.addListener(this);
        }
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addComponentListener(this);
    }

    private void adjustImageSize() {
        if (this.originalImage != null) {
            double min = Math.min((double)this.getWidth() / (double)this.originalImageWidth, (double)this.getHeight() / (double)this.originalImageHeight);
            this.imageWidth = (int)(min * (double)this.originalImageWidth);
            this.imageHeight = (int)(min * (double)this.originalImageHeight);
            this.compositeImage = new BufferedImage(this.imageWidth, this.imageHeight, 1);
            Graphics2D g2d = this.compositeImage.createGraphics();
            g2d.drawImage(this.originalImage, 0, 0, this.imageWidth, this.imageHeight, null);
            g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g2d.setPaint(Color.GRAY);
            g2d.fillRect(0, 0, this.imageWidth, this.imageHeight);
            this.image = new BufferedImage(this.imageWidth, this.imageHeight, 1);
            g2d = this.image.createGraphics();
            g2d.drawImage(this.originalImage, 0, 0, this.imageWidth, this.imageHeight, null);
            this.repaint();
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.composite) {
            g.drawImage(this.compositeImage, 0, 0, this);
            g.drawImage(this.image, this.p.x, this.p.y, this.p.x + this.p.width, this.p.y + this.p.height, this.p.x, this.p.y, this.p.x + this.p.width, this.p.y + this.p.height, this);
            if (null == this.firstClick && null != this.image) {
                g.setXORMode(Color.WHITE);
                g.drawRect(this.p.x, this.p.y, this.p.width, this.p.height);
            }
        } else {
            g.drawImage(this.image, 0, 0, this);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (null != this.firstClick) {
            Point mouseLocation = e.getPoint();
            int xOffset = mouseLocation.x - this.firstClick.x;
            int yOffset = mouseLocation.y - this.firstClick.y;
            switch (this.dragMode) {
                case 0: {
                    int newX = this.firstLocation.x + xOffset;
                    int newY = this.firstLocation.y + yOffset;
                    if (newX >= 0 && newX <= this.imageWidth && newX + this.p.width >= 0 && newX + this.p.width <= this.imageWidth) {
                        this.p.x = newX;
                    }
                    if (newY < 0 || newY > this.imageHeight || newY + this.p.height < 0 || newY + this.p.height > this.imageHeight) break;
                    this.p.y = newY;
                    break;
                }
                case 1: {
                    int newHeight = this.firstLocation.height + yOffset;
                    if (this.p.y + newHeight < 0 || this.p.y + newHeight > this.imageHeight) break;
                    this.p.height = newHeight;
                    break;
                }
                case 2: {
                    int newWidth = this.firstLocation.width + xOffset;
                    if (this.p.x + newWidth < 0 || this.p.x + newWidth > this.imageWidth) break;
                    this.p.width = newWidth;
                    break;
                }
                case 3: {
                    int newHeight;
                    int newWidth = this.firstLocation.width + xOffset;
                    if (this.p.x + newWidth >= 0 && this.p.x + newWidth <= this.imageWidth) {
                        this.p.width = newWidth;
                    }
                    if (this.p.y + (newHeight = this.firstLocation.height + yOffset) < 0 || this.p.y + newHeight > this.imageHeight) break;
                    this.p.height = newHeight;
                    break;
                }
            }
            this.repaint();
        }
    }

    private void adjustBorder() {
        this.top.setBounds(this.p.x + 15, this.p.y, this.p.width - 30, 10);
        this.bottom.setBounds(this.p.x + 15, this.p.y + this.p.height - 10, this.p.width - 30, 10);
        this.left.setBounds(this.p.x, this.p.y + 15, 10, this.p.height - 30);
        this.right.setBounds(this.p.x + this.p.width - 10, this.p.y + 15, 10, this.p.height - 30);
        this.leftTop.setBounds(this.p.x, this.p.y, 15, 15);
        this.rightTop.setBounds(this.p.x + this.p.width - 15, this.p.y, 15, 15);
        this.leftBottom.setBounds(this.p.x, this.p.y + this.p.height - 15, 15, 15);
        this.rightBottom.setBounds(this.p.x + this.p.width - 15, this.p.y + this.p.height - 15, 15, 15);
    }

    public void mousePressed(MouseEvent e) {
        Point mouseClick;
        this.firstClick = mouseClick = e.getPoint();
        this.composite = true;
        if (this.p.contains(mouseClick)) {
            if (this.top.contains(mouseClick)) {
                this.dragMode = 1;
                this.p.y += this.p.height;
                this.p.height = -this.p.height;
            } else if (this.bottom.contains(mouseClick)) {
                this.dragMode = 1;
            } else if (this.left.contains(mouseClick)) {
                this.dragMode = 2;
                this.p.x += this.p.width;
                this.p.width = -this.p.width;
            } else if (this.right.contains(mouseClick)) {
                this.dragMode = 2;
            } else if (this.leftTop.contains(mouseClick)) {
                this.dragMode = 3;
                this.p.x += this.p.width;
                this.p.y += this.p.height;
                this.p.width = -this.p.width;
                this.p.height = -this.p.height;
            } else if (this.rightTop.contains(mouseClick)) {
                this.dragMode = 3;
                this.p.y += this.p.height;
                this.p.height = -this.p.height;
            } else if (this.leftBottom.contains(mouseClick)) {
                this.dragMode = 3;
                this.p.x += this.p.width;
                this.p.width = -this.p.width;
            } else {
                this.dragMode = this.rightBottom.contains(mouseClick) ? 3 : 0;
            }
        } else {
            this.dragMode = 3;
            this.p.x = mouseClick.x;
            this.p.y = mouseClick.y;
            this.p.width = 0;
            this.p.height = 0;
        }
        this.firstLocation.setBounds(this.p);
    }

    public void mouseMoved(MouseEvent e) {
        Point mouseLocation = e.getPoint();
        if (this.top.contains(mouseLocation)) {
            this.setCursor(Cursor.getPredefinedCursor(8));
        } else if (this.bottom.contains(mouseLocation)) {
            this.setCursor(Cursor.getPredefinedCursor(9));
        } else if (this.left.contains(mouseLocation)) {
            this.setCursor(Cursor.getPredefinedCursor(10));
        } else if (this.right.contains(mouseLocation)) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else if (this.leftTop.contains(mouseLocation)) {
            this.setCursor(Cursor.getPredefinedCursor(6));
        } else if (this.rightTop.contains(mouseLocation)) {
            this.setCursor(Cursor.getPredefinedCursor(7));
        } else if (this.leftBottom.contains(mouseLocation)) {
            this.setCursor(Cursor.getPredefinedCursor(4));
        } else if (this.rightBottom.contains(mouseLocation)) {
            this.setCursor(Cursor.getPredefinedCursor(5));
        } else if (this.p.contains(mouseLocation)) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.setCursor(null);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (!this.p.contains(e.getPoint())) {
            Object[] supported = this.br_xCapability.getSupportedValues();
            double maxWidth = Double.parseDouble((String)supported[supported.length - 1]);
            supported = this.br_yCapability.getSupportedValues();
            double maxHeight = Double.parseDouble((String)supported[supported.length - 1]);
            try {
                this.tl_xCapability.setValue("0");
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                this.tl_yCapability.setValue("0");
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                this.br_xCapability.setValue(String.valueOf(maxWidth));
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                this.br_yCapability.setValue(String.valueOf(maxHeight));
            }
            catch (Exception e1) {
                // empty catch block
            }
            this.p.x = 0;
            this.p.y = 0;
            this.p.width = 0;
            this.p.height = 0;
            this.adjustBorder();
            this.composite = false;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        block13: {
            double maxHeight;
            block12: {
                double maxWidth;
                block11: {
                    block10: {
                        this.firstClick = null;
                        if (this.p.width < 0) {
                            this.p.x += this.p.width;
                            this.p.width = -this.p.width;
                        }
                        if (this.p.height < 0) {
                            this.p.y += this.p.height;
                            this.p.height = -this.p.height;
                        }
                        this.tl_xCapability.setSelected(true);
                        this.tl_yCapability.setSelected(true);
                        this.br_xCapability.setSelected(true);
                        this.br_yCapability.setSelected(true);
                        Object[] supported = this.br_xCapability.getSupportedValues();
                        maxWidth = Double.parseDouble((String)supported[supported.length - 1]);
                        supported = this.br_yCapability.getSupportedValues();
                        maxHeight = Double.parseDouble((String)supported[supported.length - 1]);
                        try {
                            this.tl_xCapability.setValue(String.valueOf((double)this.p.x * maxWidth / (double)this.imageWidth));
                        }
                        catch (Exception e1) {
                            if (!Capabilities.debug) break block10;
                            System.out.println("PreviewCanvas.mouseReleased()" + e1.getMessage() + " caused by " + e1.getCause());
                        }
                    }
                    try {
                        this.tl_yCapability.setValue(String.valueOf((double)this.p.y * maxHeight / (double)this.imageHeight));
                    }
                    catch (Exception e1) {
                        if (!Capabilities.debug) break block11;
                        System.out.println("PreviewCanvas.mouseReleased()" + e1.getMessage() + " caused by " + e1.getCause());
                    }
                }
                try {
                    this.br_xCapability.setValue(String.valueOf((double)(this.p.x + this.p.width) * maxWidth / (double)this.imageWidth));
                }
                catch (Exception e1) {
                    if (!Capabilities.debug) break block12;
                    System.out.println("PreviewCanvas.mouseReleased()" + e1.getMessage() + " caused by " + e1.getCause());
                }
            }
            try {
                this.br_yCapability.setValue(String.valueOf((double)(this.p.y + this.p.height) * maxHeight / (double)this.imageHeight));
            }
            catch (Exception e1) {
                if (!Capabilities.debug) break block13;
                System.out.println("PreviewCanvas.mouseReleased()" + e1.getMessage() + " caused by " + e1.getCause());
            }
        }
        this.adjustBorder();
        this.repaint();
    }

    public void componentHidden(ComponentEvent arg0) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.dragMode = 3;
        this.p.x = 0;
        this.p.y = 0;
        this.p.width = 0;
        this.p.height = 0;
        this.repaint();
        if (this.originalImage != null) {
            this.adjustImageSize();
            this.composite = false;
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public void setImage(Image image) {
        if (null != image) {
            this.originalImage = image;
            this.originalImageWidth = this.originalImage.getWidth(this);
            this.originalImageHeight = this.originalImage.getHeight(this);
            Object[] supported = this.br_xCapability.getSupportedValues();
            double maxWidth = Double.parseDouble((String)supported[supported.length - 1]);
            supported = this.br_yCapability.getSupportedValues();
            double maxHeight = Double.parseDouble((String)supported[supported.length - 1]);
            double tl_x = (Double)this.tl_xCapability.getValue();
            double tl_y = (Double)this.tl_yCapability.getValue();
            double br_x = (Double)this.br_xCapability.getValue();
            double br_y = (Double)this.br_yCapability.getValue();
            if (tl_x > 0.01 && tl_y > 0.01 && maxWidth - br_x > 0.01 && maxHeight - br_y > 0.01) {
                this.adjustImageSize();
                this.composite = true;
                this.p.x = (int)((double)this.imageWidth * tl_x / maxWidth + 0.5);
                this.p.y = (int)((double)this.imageHeight * tl_y / maxHeight + 0.5);
                this.p.width = (int)((double)this.imageWidth * br_x / maxWidth - (double)this.p.x + 0.5);
                this.p.height = (int)((double)this.imageHeight * br_y / maxHeight - (double)this.p.y + 0.5);
                this.adjustBorder();
            } else {
                this.adjustImageSize();
                this.composite = false;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Capability capability = (Capability)evt.getSource();
        String propertyName = capability.getName();
        double value = (Double)capability.getValue();
        Object[] supported = this.br_xCapability.getSupportedValues();
        double maxWidth = Double.parseDouble((String)supported[supported.length - 1]);
        supported = this.br_yCapability.getSupportedValues();
        double maxHeight = Double.parseDouble((String)supported[supported.length - 1]);
        if (propertyName.equals("tl-x")) {
            int temp = this.p.x + this.p.width;
            this.p.x = (int)((double)this.imageWidth * value / maxWidth + 0.5);
            this.p.width = temp - this.p.x;
        } else if (propertyName.equals("br-x")) {
            this.p.width = (int)((double)this.imageWidth * value / maxWidth - (double)this.p.x + 0.5);
        } else if (propertyName.equals("tl-y")) {
            int temp = this.p.y + this.p.height;
            this.p.y = (int)((double)this.imageHeight * value / maxHeight + 0.5);
            this.p.height = temp - this.p.y;
        } else if (propertyName.equals("br-y")) {
            this.p.height = (int)((double)this.imageHeight * value / maxHeight - (double)this.p.y + 0.5);
        }
        this.adjustBorder();
        this.repaint();
    }
}

