/*
 * Decompiled with CFR 0.152.
 */
package SK.gnome.capabilities.sane;

import SK.gnome.capabilities.Capabilities;
import SK.gnome.capabilities.Capability;
import SK.gnome.capabilities.CapabilityDialog;
import SK.gnome.capabilities.sane.SaneCapability;
import SK.gnome.morena.MorenaConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class SaneSelectOptionsDialog
extends JDialog
implements ActionListener,
MorenaConstants {
    private CapabilityDialog saneDialog;
    private Capabilities capabilities;
    private JPanel tabPanels;
    private Frame frame;

    public SaneSelectOptionsDialog(Frame frame, Capabilities capabilities, CapabilityDialog saneDialog) {
        super(frame, capabilities.getSourceName(), true);
        int height;
        this.frame = frame;
        this.saneDialog = saneDialog;
        this.capabilities = capabilities;
        Container contentPane = this.getContentPane();
        JPanel mainContainerPanel = new JPanel();
        mainContainerPanel.setLayout(new BoxLayout(mainContainerPanel, 1));
        this.tabPanels = new JPanel();
        this.tabPanels.setLayout(new BoxLayout(this.tabPanels, 0));
        this.tabPanels.setAlignmentX(0.0f);
        Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        Font font = this.getFont();
        Font newFont = new Font(font.getFontName(), 1, 16);
        this.tabPanels.setBorder(BorderFactory.createTitledBorder(border, MORENA_MESSAGES.getString("SELECT_FROM_SUPPORTED_OPTIONS"), 2, 2, newFont));
        JPanel tabPanel = new JPanel();
        tabPanel.setAlignmentY(0.0f);
        tabPanel.setLayout(new BoxLayout(tabPanel, 1));
        for (Capability capability : capabilities.getCapabilities()) {
            String name;
            SaneCapability saneOption = (SaneCapability)capability;
            if (saneOption.getType() == 5) {
                if (0 != tabPanel.getComponentCount()) {
                    this.tabPanels.add(tabPanel);
                    tabPanel = new JPanel();
                    tabPanel.setLayout(new BoxLayout(tabPanel, 1));
                    tabPanel.setAlignmentY(0.0f);
                }
                tabPanel.setBorder(BorderFactory.createTitledBorder(saneOption.getTitle()));
                continue;
            }
            if (0 != (saneOption.getCap() & 0x20) || (name = saneOption.getName()).equals("preview")) continue;
            JCheckBox checkBox = new JCheckBox(saneOption.getTitle());
            checkBox.setName(name);
            checkBox.setSelected(saneOption.isSelected());
            tabPanel.add(checkBox);
        }
        if (0 != tabPanel.getComponentCount()) {
            this.tabPanels.add(tabPanel);
            tabPanel = new JPanel();
            tabPanel.setLayout(new BoxLayout(tabPanel, 1));
            tabPanel.setAlignmentY(0.0f);
        }
        mainContainerPanel.add(this.tabPanels);
        mainContainerPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JButton button = new JButton(MORENA_MESSAGES.getString("PREFERENCES"));
        button.setActionCommand("PreferencesButton");
        button.addActionListener(this);
        mainContainerPanel.add(button);
        button = new JButton("OK");
        button.setFont(new Font("Arial", 1, 18));
        button.setActionCommand("OKButton");
        button.addActionListener(this);
        JPanel panel2 = new JPanel();
        panel2.add(button);
        contentPane.add((Component)panel2, "Last");
        JScrollPane scrollPane = new JScrollPane(mainContainerPanel);
        contentPane.add(scrollPane);
        this.pack();
        this.validate();
        int width = this.getWidth();
        if (width > 800) {
            width = 800;
        }
        if ((height = this.getHeight()) > 600) {
            height = 600;
        }
        this.setSize(new Dimension(width + 20, height + 20));
        this.setLocationByPlatform(true);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OKButton")) {
            Component[] tabPanelsArray = this.tabPanels.getComponents();
            for (int j = 0; j < tabPanelsArray.length; ++j) {
                Component[] checkBoxArray = ((JPanel)tabPanelsArray[j]).getComponents();
                block1: for (int i = 0; i < checkBoxArray.length; ++i) {
                    JCheckBox checkBox = (JCheckBox)checkBoxArray[i];
                    String capabilityName = checkBox.getName();
                    for (Capability capability : this.capabilities.getCapabilities()) {
                        String name = capability.getName();
                        if (name == null || !name.equals(capabilityName)) continue;
                        capability.setSelected(checkBox.isSelected());
                        continue block1;
                    }
                }
            }
            this.saneDialog.updateCapabilitiesTable();
            this.dispose();
        } else if (e.getActionCommand().equals("PreferencesButton")) {
            class PreferencesOptionPane
            extends JPanel {
                private JCheckBox restartAfterPreviewCheckBox;
                private JTextField sleepTimeBeforeRestartTextField;

                public PreferencesOptionPane(boolean restartAfterPreview, int sleepTimeBeforeRestart) {
                    this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    this.setLayout(new BoxLayout(this, 1));
                    this.setAlignmentX(0.0f);
                    this.restartAfterPreviewCheckBox = new JCheckBox(MorenaConstants.MORENA_MESSAGES.getString("RESTART_AFTER_PREVIEW"));
                    this.restartAfterPreviewCheckBox.setSelected(SaneSelectOptionsDialog.this.capabilities.isRestartAfterPreview());
                    this.add(this.restartAfterPreviewCheckBox);
                    JPanel restartPanel = new JPanel();
                    restartPanel.setLayout(new BoxLayout(restartPanel, 0));
                    restartPanel.setAlignmentX(0.0f);
                    JLabel label = new JLabel(MorenaConstants.MORENA_MESSAGES.getString("SLEEP_TIME_BEFORE_NEW_START") + ":  ");
                    label.setAlignmentX(0.0f);
                    restartPanel.add(label);
                    this.sleepTimeBeforeRestartTextField = new JTextField(String.valueOf(SaneSelectOptionsDialog.this.capabilities.getSleepTimeBeforeRestart()), 6);
                    this.sleepTimeBeforeRestartTextField.setAlignmentX(0.0f);
                    restartPanel.add(this.sleepTimeBeforeRestartTextField);
                    this.add(restartPanel);
                }

                public boolean isRestartAfterPreview() {
                    return this.restartAfterPreviewCheckBox.isSelected();
                }

                public int getSleepTimeBeforeRestart() {
                    return Integer.parseInt(this.sleepTimeBeforeRestartTextField.getText());
                }
            }
            PreferencesOptionPane preferencesOptionPane = new PreferencesOptionPane(this.capabilities.isRestartAfterPreview(), this.capabilities.getSleepTimeBeforeRestart());
            JOptionPane.showMessageDialog(this.frame, preferencesOptionPane, MORENA_MESSAGES.getString("PREFERENCES"), 1);
            this.capabilities.setRestartAfterPreview(preferencesOptionPane.isRestartAfterPreview());
            this.capabilities.setSleepTimeBeforeRestart(preferencesOptionPane.getSleepTimeBeforeRestart());
        }
    }
}

