/*
 * Decompiled with CFR 0.152.
 */
package SK.gnome.capabilities.twain;

import SK.gnome.capabilities.Capabilities;
import SK.gnome.capabilities.Capability;
import SK.gnome.capabilities.twain.TwainActivity;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class TwainCapability
extends Capability {
    private TwainActivity twainActivity;
    private int type;
    protected boolean supported = true;
    private String constantAbbreviation = null;
    private String defaultValue = null;
    private String[] supportedValues = null;
    private boolean setMethodSupported = false;

    public TwainCapability(TwainActivity twainActivity, String name, int type, String constantAbbreviation, Properties properties) {
        this.twainActivity = twainActivity;
        this.name = name;
        this.title = name;
        this.type = type;
        this.constantAbbreviation = constantAbbreviation;
        String value = this.getValue();
        if (null == value) {
            this.supported = false;
        }
        if (this.supported) {
            block9: {
                try {
                    this.defaultValue = this.getDefaultValue();
                }
                catch (Exception e) {
                    if (!Capabilities.debug) break block9;
                    System.out.println("TwainCapability.TwainCapability().getDefaultValue() failed: " + e.getMessage() + " caused by " + e.getCause());
                }
            }
            this.supportedValues = this.getSupportedValues();
            try {
                this.setValue(value);
                this.setMethodSupported = true;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.setMethodSupported && properties.containsKey(name)) {
                block10: {
                    value = properties.getProperty(this.getName(), this.defaultValue);
                    try {
                        this.setValue(value);
                    }
                    catch (Exception e) {
                        if (!Capabilities.debug) break block10;
                        System.out.println("TwainCapability.TwainCapability().setValue(" + value + ") failed: " + e.getMessage() + " caused by " + e.getCause());
                    }
                }
                this.selected = true;
            }
        }
    }

    public String getDefaultValue() throws Exception {
        String defaultValue = null;
        String methodName = "getDefault" + this.name;
        Class[] types = new Class[]{};
        Method method = this.twainActivity.getSource().getClass().getMethod(methodName, types);
        switch (this.type) {
            case 0: {
                Integer object = (Integer)method.invoke((Object)this.twainActivity.getSource(), new Object[0]);
                defaultValue = String.valueOf(object);
                break;
            }
            case 2: {
                Boolean object2 = (Boolean)method.invoke((Object)this.twainActivity.getSource(), new Object[0]);
                defaultValue = String.valueOf(object2);
                break;
            }
            case 1: {
                Double object3 = (Double)method.invoke((Object)this.twainActivity.getSource(), new Object[0]);
                defaultValue = String.valueOf(object3);
                break;
            }
            case 3: {
                defaultValue = (String)method.invoke((Object)this.twainActivity.getSource(), new Object[0]);
            }
        }
        if (null != defaultValue && null != this.constantAbbreviation) {
            Hashtable<String, String> ht = TwainActivity.twainConstantsValues.get(this.constantAbbreviation);
            return ht.get(defaultValue);
        }
        return defaultValue;
    }

    public void setValue(String argument) throws Exception {
        String methodName = "set" + this.name;
        if (null != argument && null != this.constantAbbreviation) {
            Hashtable<String, String> ht = TwainActivity.twainConstants.get(this.constantAbbreviation);
            argument = ht.get(argument);
        }
        try {
            switch (this.type) {
                case 0: {
                    Class[] types = new Class[]{Integer.TYPE};
                    Method method = this.twainActivity.getSource().getClass().getMethod(methodName, types);
                    method.invoke((Object)this.twainActivity.getSource(), new Integer(argument));
                    break;
                }
                case 2: {
                    Class[] types = new Class[]{Boolean.TYPE};
                    Method method = this.twainActivity.getSource().getClass().getMethod(methodName, types);
                    method.invoke((Object)this.twainActivity.getSource(), new Boolean(argument));
                    break;
                }
                case 1: {
                    Class[] types = new Class[]{Double.TYPE};
                    Method method = this.twainActivity.getSource().getClass().getMethod(methodName, types);
                    method.invoke((Object)this.twainActivity.getSource(), new Double(argument));
                    break;
                }
                case 3: {
                    Class[] types = new Class[]{String.class};
                    Method method = this.twainActivity.getSource().getClass().getMethod(methodName, types);
                    method.invoke((Object)this.twainActivity.getSource(), new String(argument));
                    break;
                }
            }
            Enumeration e2 = this.listeners.elements();
            while (e2.hasMoreElements()) {
                PropertyChangeListener listener = (PropertyChangeListener)e2.nextElement();
                listener.propertyChange(new PropertyChangeEvent(this, null, null, null));
            }
        }
        catch (Exception e) {
            Enumeration e2 = this.listeners.elements();
            while (e2.hasMoreElements()) {
                PropertyChangeListener listener = (PropertyChangeListener)e2.nextElement();
                listener.propertyChange(new PropertyChangeEvent(this, null, null, null));
            }
            throw e;
        }
    }

    public String getValue() {
        String value = null;
        String methodName = "get" + this.name;
        Class[] types = new Class[]{};
        try {
            Method method = this.twainActivity.getSource().getClass().getMethod(methodName, types);
            switch (this.type) {
                case 0: {
                    Integer object = (Integer)method.invoke((Object)this.twainActivity.getSource(), new Object[0]);
                    value = String.valueOf(object);
                    break;
                }
                case 2: {
                    Boolean object2 = (Boolean)method.invoke((Object)this.twainActivity.getSource(), new Object[0]);
                    value = String.valueOf(object2);
                    break;
                }
                case 1: {
                    Double object3 = (Double)method.invoke((Object)this.twainActivity.getSource(), new Object[0]);
                    value = String.valueOf(object3);
                    break;
                }
                case 3: {
                    value = (String)method.invoke((Object)this.twainActivity.getSource(), new Object[0]);
                }
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (null != value && null != this.constantAbbreviation) {
            Hashtable<String, String> ht = TwainActivity.twainConstantsValues.get(this.constantAbbreviation);
            return ht.get(value);
        }
        return value;
    }

    public String[] getSupportedValues() {
        String methodName = "getSupported" + this.name;
        try {
            this.supportedValues = null;
            Class[] types = new Class[]{};
            Method method = this.twainActivity.getSource().getClass().getMethod(methodName, types);
            switch (this.type) {
                case 0: {
                    int[] object = (int[])method.invoke((Object)this.twainActivity.getSource(), new Object[0]);
                    this.supportedValues = new String[object.length];
                    for (int i = 0; i < object.length; ++i) {
                        this.supportedValues[i] = String.valueOf(object[i]);
                    }
                    break;
                }
                case 2: {
                    boolean[] object2 = (boolean[])method.invoke((Object)this.twainActivity.getSource(), new Object[0]);
                    this.supportedValues = new String[object2.length];
                    for (int i = 0; i < object2.length; ++i) {
                        this.supportedValues[i] = String.valueOf(object2[i]);
                    }
                    break;
                }
                case 1: {
                    double[] object3 = (double[])method.invoke((Object)this.twainActivity.getSource(), new Object[0]);
                    this.supportedValues = new String[object3.length];
                    for (int i = 0; i < object3.length; ++i) {
                        this.supportedValues[i] = String.valueOf(object3[i]);
                    }
                    break;
                }
                case 3: {
                    this.supportedValues = (String[])method.invoke((Object)this.twainActivity.getSource(), new Object[0]);
                }
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e1) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (null != this.supportedValues && null != this.constantAbbreviation) {
            Hashtable<String, String> ht = TwainActivity.twainConstantsValues.get(this.constantAbbreviation);
            String[] sv = new String[this.supportedValues.length];
            for (int i = 0; i < sv.length; ++i) {
                sv[i] = ht.get(this.supportedValues[i]);
            }
            return sv;
        }
        return this.supportedValues;
    }

    public boolean isSetMethodSupported() {
        return this.setMethodSupported;
    }

    public boolean isSupported() {
        return this.supported;
    }
}

