/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg;

import com.idrsolutions.image.jpeg.Component;
import com.idrsolutions.image.jpeg.Frame;
import com.idrsolutions.image.jpeg.HTree;
import com.idrsolutions.image.jpeg.JpegDecoder;
import com.idrsolutions.image.jpeg.JpegLUT;
import java.util.List;

public class JpegScanner {
    private static final int DCFirst = 0;
    private static final int DCSuccessive = 1;
    private static final int ACFirst = 2;
    private static final int ACSuccessive = 3;
    private static final int Baseline = 4;
    private final byte[] data;
    private int bitPos;
    private int bitBuffer;
    private int eobrun;
    private int mcusX;
    private int offset;
    private int successive;
    private int sStart;
    private int sEnd;
    private int stateAC;
    private int stateNextAC;

    public JpegScanner(byte[] byArray) {
        this.data = byArray;
    }

    public int decodeScan(int n, Frame frame, List<Component> list, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        this.mcusX = frame.mcusX;
        this.offset = n;
        this.successive = n6;
        this.sStart = n3;
        this.sEnd = n4;
        int n8 = list.size();
        int n9 = frame.progressive ? (n3 == 0 ? (n5 == 0 ? 0 : 1) : (n5 == 0 ? 2 : 3)) : 4;
        int n10 = 0;
        int n11 = n8 == 1 ? list.get((int)0).blocksX * list.get((int)0).blocksY : this.mcusX * frame.mcusY;
        int n12 = n7 = n2 == 0 ? n11 : n2;
        while (n10 < n11) {
            int n13;
            Component component;
            int n14;
            for (n14 = 0; n14 < n8; ++n14) {
                list.get((int)n14).pred = 0;
            }
            this.eobrun = 0;
            if (n8 == 1) {
                component = list.get(0);
                for (n13 = 0; n13 < n7; ++n13) {
                    this.decodeBlock(component, n9, n10);
                    ++n10;
                }
            } else {
                for (n13 = 0; n13 < n7; ++n13) {
                    for (n14 = 0; n14 < n8; ++n14) {
                        component = list.get(n14);
                        int n15 = component.h;
                        int n16 = component.v;
                        for (int i = 0; i < n16; ++i) {
                            for (int j = 0; j < n15; ++j) {
                                this.decodeMcu(component, n9, n10, i, j);
                            }
                        }
                    }
                    ++n10;
                }
            }
            this.bitPos = 0;
            int n17 = (this.data[this.offset] & 0xFF) << 8 | this.data[this.offset + 1] & 0xFF;
            if (n17 <= 65280) {
                // empty if block
            }
            if (n17 < 65488 || n17 > 65495) break;
            this.offset += 2;
        }
        return this.offset - n;
    }

    private int findHuffmanValue(HTree hTree) {
        HTree hTree2 = hTree;
        do {
            hTree2 = hTree2.nodes[this.readBit()];
        } while (!hTree2.isEnd);
        return hTree2.value;
    }

    private int readBit() {
        int n;
        if (this.bitPos > 0) {
            --this.bitPos;
            return this.bitBuffer >> this.bitPos & 1;
        }
        this.bitBuffer = this.data[this.offset++] & 0xFF;
        if (this.bitBuffer == 255 && (n = this.data[this.offset++] & 0xFF) != 0 && JpegDecoder.debug) {
            System.err.println("invalid marker found");
        }
        this.bitPos = 7;
        return this.bitBuffer >>> 7;
    }

    private int getNext(int n) {
        int n2 = 0;
        while (n > 0) {
            n2 = n2 << 1 | this.readBit();
            --n;
        }
        return n2;
    }

    private int getNextFull(int n) {
        if (n == 1) {
            return this.readBit() == 1 ? 1 : -1;
        }
        int n2 = this.getNext(n);
        if (n2 >= 1 << n - 1) {
            return n2;
        }
        return n2 + (-1 << n) + 1;
    }

    private void decodeMcu(Component component, int n, int n2, int n3, int n4) {
        int n5 = n2 / this.mcusX;
        int n6 = n2 % this.mcusX;
        int n7 = n5 * component.v + n3;
        int n8 = n6 * component.h + n4;
        int n9 = JpegScanner.getCodeBlockOffset(component, n7, n8);
        this.decodeOrdering(component, n9, n);
    }

    private void decodeBlock(Component component, int n, int n2) {
        int n3 = n2 / component.blocksX;
        int n4 = n2 % component.blocksX;
        int n5 = JpegScanner.getCodeBlockOffset(component, n3, n4);
        this.decodeOrdering(component, n5, n);
    }

    private void decodeOrdering(Component component, int n, int n2) {
        block0 : switch (n2) {
            case 0: {
                int n3 = this.findHuffmanValue(component.huffmanTableDC);
                int n4 = n3 == 0 ? 0 : this.getNextFull(n3) << this.successive;
                component.codeBlock[n] = component.pred += n4;
                break;
            }
            case 1: {
                int n5 = n;
                component.codeBlock[n5] = component.codeBlock[n5] | this.readBit() << this.successive;
                break;
            }
            case 2: {
                if (this.eobrun > 0) {
                    --this.eobrun;
                    return;
                }
                int n6 = this.sStart;
                int n7 = this.sEnd;
                while (n6 <= n7) {
                    int n8 = this.findHuffmanValue(component.huffmanTableAC);
                    int n9 = n8 & 0xF;
                    int n10 = n8 >> 4;
                    if (n9 == 0) {
                        if (n10 < 15) {
                            this.eobrun = this.getNext(n10) + (1 << n10) - 1;
                            break block0;
                        }
                        n6 += 16;
                        continue;
                    }
                    byte by = JpegLUT.ZIGZAGORDER[n6 += n10];
                    component.codeBlock[n + by] = this.getNextFull(n9) * (1 << this.successive);
                    ++n6;
                }
                break;
            }
            case 3: {
                int n11 = this.sStart;
                int n12 = this.sEnd;
                int n13 = 0;
                block14: while (n11 <= n12) {
                    byte by = JpegLUT.ZIGZAGORDER[n11];
                    switch (this.stateAC) {
                        case 0: {
                            int n14 = this.findHuffmanValue(component.huffmanTableAC);
                            int n15 = n14 & 0xF;
                            n13 = n14 >> 4;
                            if (n15 == 0) {
                                if (n13 < 15) {
                                    this.eobrun = this.getNext(n13) + (1 << n13);
                                    this.stateAC = 4;
                                    continue block14;
                                }
                                n13 = 16;
                                this.stateAC = 1;
                                continue block14;
                            }
                            if (n15 != 1) {
                                // empty if block
                            }
                            this.stateNextAC = this.getNextFull(n15);
                            this.stateAC = n13 != 0 ? 2 : 3;
                            continue block14;
                        }
                        case 1: 
                        case 2: {
                            if (component.codeBlock[n + by] != 0) {
                                int n16 = n + by;
                                component.codeBlock[n16] = component.codeBlock[n16] + (this.readBit() << this.successive);
                                break;
                            }
                            if (--n13 != 0) break;
                            this.stateAC = this.stateAC == 2 ? 3 : 0;
                            break;
                        }
                        case 3: {
                            if (component.codeBlock[n + by] != 0) {
                                int n17 = n + by;
                                component.codeBlock[n17] = component.codeBlock[n17] + (this.readBit() << this.successive);
                                break;
                            }
                            component.codeBlock[n + by] = this.stateNextAC << this.successive;
                            this.stateAC = 0;
                            break;
                        }
                        case 4: {
                            if (component.codeBlock[n + by] == 0) break;
                            int n18 = n + by;
                            component.codeBlock[n18] = component.codeBlock[n18] + (this.readBit() << this.successive);
                        }
                    }
                    ++n11;
                }
                if (this.stateAC != 4) break;
                --this.eobrun;
                if (this.eobrun != 0) break;
                this.stateAC = 0;
                break;
            }
            case 4: {
                int n19 = this.findHuffmanValue(component.huffmanTableDC);
                int n20 = n19 == 0 ? 0 : this.getNextFull(n19);
                component.codeBlock[n] = component.pred += n20;
                int n21 = 1;
                while (n21 < 64) {
                    int n22 = this.findHuffmanValue(component.huffmanTableAC);
                    int n23 = n22 & 0xF;
                    int n24 = n22 >> 4;
                    if (n23 == 0) {
                        if (n24 < 15) break block0;
                        n21 += 16;
                        continue;
                    }
                    byte by = JpegLUT.ZIGZAGORDER[n21 += n24];
                    component.codeBlock[n + by] = this.getNextFull(n23);
                    ++n21;
                }
                break;
            }
        }
    }

    public static int getCodeBlockOffset(Component component, int n, int n2) {
        return 64 * ((component.blocksX + 1) * n + n2);
    }
}

