/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.CodeBlock;
import com.idrsolutions.image.jpeg2000.Info;
import com.idrsolutions.image.jpeg2000.Packet;
import com.idrsolutions.image.jpeg2000.Progression;
import com.idrsolutions.image.jpeg2000.SIZ;
import com.idrsolutions.image.jpeg2000.Tile;
import com.idrsolutions.image.jpeg2000.TileBand;
import com.idrsolutions.image.jpeg2000.TileComponent;
import com.idrsolutions.image.jpeg2000.TileResolution;
import java.awt.Rectangle;

public class CPRL
implements Progression {
    private final int layersCount;
    private final int componentsCount;
    private final Tile tile;
    private final ImagePrecinctInfo precinctsSizes;
    int l;
    int r;
    int c;
    int px;
    int py;
    int k;

    public CPRL(Info info, int n) {
        SIZ sIZ = info.siz;
        this.tile = info.tilesMap.get(n);
        this.layersCount = this.tile.cod.nLayers;
        this.componentsCount = sIZ.nComp;
        this.precinctsSizes = CPRL.findImagePrecinctInfo(this.tile);
    }

    @Override
    public Packet getNextPacket() {
        while (this.c < this.componentsCount) {
            TileComponent tileComponent = this.tile.components.get(this.c);
            SizeComponentInfo sizeComponentInfo = this.precinctsSizes.components[this.c];
            int n = this.tile.cod.nDecompLevel;
            while (this.py < sizeComponentInfo.maxNumHigh) {
                while (this.px < sizeComponentInfo.maxNumWide) {
                    while (this.r <= n) {
                        TileResolution tileResolution = tileComponent.resolutions.get(this.r);
                        Rectangle rectangle = sizeComponentInfo.resolutions[this.r];
                        boolean bl = CPRL.hasPrecinctIndex(this.px, this.py, rectangle, sizeComponentInfo);
                        if (!bl) {
                            ++this.r;
                            continue;
                        }
                        this.k = CPRL.getPrecinctIndex(this.px, this.py, rectangle, sizeComponentInfo, tileResolution);
                        if (this.l < this.layersCount) {
                            Packet packet = this.createPacket(tileResolution, this.k, this.l);
                            ++this.l;
                            return packet;
                        }
                        this.l = 0;
                        ++this.r;
                    }
                    this.r = 0;
                    ++this.px;
                }
                this.px = 0;
                ++this.py;
            }
            this.py = 0;
            ++this.c;
        }
        return null;
    }

    @Override
    public Packet createPacket(TileResolution tileResolution, int n, int n2) {
        Packet packet = new Packet();
        packet.layerNumber = n2;
        for (TileBand tileBand : tileResolution.tileBands) {
            for (CodeBlock codeBlock : tileBand.codeBlocks) {
                if (codeBlock.precinctNumber != n) continue;
                packet.codeBlocks.add(codeBlock);
            }
        }
        return packet;
    }

    private static boolean hasPrecinctIndex(int n, int n2, Rectangle rectangle, SizeComponentInfo sizeComponentInfo) {
        int n3 = n * sizeComponentInfo.minWidth;
        int n4 = n2 * sizeComponentInfo.minHeight;
        return n3 % rectangle.width == 0 && n4 % rectangle.height == 0;
    }

    private static int getPrecinctIndex(int n, int n2, Rectangle rectangle, SizeComponentInfo sizeComponentInfo, TileResolution tileResolution) {
        int n3 = n * sizeComponentInfo.minWidth;
        int n4 = n2 * sizeComponentInfo.minHeight;
        int n5 = n4 / rectangle.width * tileResolution.precinctInfo.numPrecinctsWide;
        return n3 / rectangle.height + n5;
    }

    private static ImagePrecinctInfo findImagePrecinctInfo(Tile tile) {
        int n = tile.components.size();
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        int n5 = 0;
        SizeComponentInfo[] sizeComponentInfoArray = new SizeComponentInfo[n];
        for (int i = 0; i < n; ++i) {
            TileComponent tileComponent = tile.components.get(i);
            int n6 = tile.cod.nDecompLevel;
            Rectangle[] rectangleArray = new Rectangle[n6 + 1];
            int n7 = Integer.MAX_VALUE;
            int n8 = Integer.MAX_VALUE;
            int n9 = 0;
            int n10 = 0;
            int n11 = 1;
            for (int j = n6; j >= 0; --j) {
                TileResolution tileResolution = tileComponent.resolutions.get(j);
                int n12 = n11 * tileResolution.precinctInfo.precinctWidth;
                int n13 = n11 * tileResolution.precinctInfo.precinctHeight;
                n7 = Math.min(n7, n12);
                n8 = Math.min(n8, n13);
                n9 = Math.max(n9, tileResolution.precinctInfo.numPrecinctsWide);
                n10 = Math.max(n10, tileResolution.precinctInfo.numPrecinctsHigh);
                rectangleArray[j] = new Rectangle(n12, n13);
                n11 <<= 1;
            }
            n2 = Math.min(n2, n7);
            n3 = Math.min(n3, n8);
            n4 = Math.max(n4, n9);
            n5 = Math.max(n5, n10);
            SizeComponentInfo sizeComponentInfo = new SizeComponentInfo();
            sizeComponentInfo.resolutions = rectangleArray;
            sizeComponentInfo.minWidth = n7;
            sizeComponentInfo.minHeight = n8;
            sizeComponentInfo.maxNumHigh = n10;
            sizeComponentInfo.maxNumWide = n9;
            sizeComponentInfoArray[i] = sizeComponentInfo;
        }
        ImagePrecinctInfo imagePrecinctInfo = new ImagePrecinctInfo();
        imagePrecinctInfo.components = sizeComponentInfoArray;
        return imagePrecinctInfo;
    }

    private static class ImagePrecinctInfo {
        SizeComponentInfo[] components;

        private ImagePrecinctInfo() {
        }
    }

    private static class SizeComponentInfo {
        Rectangle[] resolutions;
        int minWidth;
        int minHeight;
        int maxNumWide;
        int maxNumHigh;

        private SizeComponentInfo() {
        }
    }
}

