/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

import com.idrsolutions.image.png.PngEncoder;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import javax.imageio.ImageIO;

public class PngCompressor {
    private static final String FILENAME = "_compressed";
    private static boolean verbose;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File file2) throws IOException {
        if (!file2.exists()) {
            file2.createNewFile();
        }
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            fileChannel = new FileInputStream(file).getChannel();
            abstractInterruptibleChannel = new FileOutputStream(file2).getChannel();
            ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
        }
    }

    private static byte[] getCompressedImageAsByteArray(BufferedImage bufferedImage, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n / 2);
        PngEncoder pngEncoder = new PngEncoder();
        pngEncoder.setCompressed(true);
        pngEncoder.write(bufferedImage, byteArrayOutputStream);
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static void writeSizeMessage(int n, int n2) {
        String string;
        if (n == n2) {
            string = " (same size)";
        } else {
            float f = 1.0f - (float)n2 / (float)n;
            f *= 100.0f;
            if (n > n2) {
                string = " (" + String.format("%.02f", Float.valueOf(f)) + "% smaller)";
            } else {
                f = -f;
                string = " (" + String.format("%.02f", Float.valueOf(f)) + "% larger)";
            }
        }
        System.out.println("Original size: " + n);
        System.out.println("Compressed size: " + n2 + string);
    }

    public static void compress(File file, File file2) throws IOException {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            System.out.println("error: Failed to read image " + file.getAbsolutePath());
            throw new IOException(iOException);
        }
        if (bufferedImage == null) {
            throw new IOException("error: Failed to read image " + file.getAbsolutePath());
        }
        int n = (int)file.length();
        byte[] byArray = PngCompressor.getCompressedImageAsByteArray(bufferedImage, n);
        if (verbose) {
            System.out.println("Input: " + file.getAbsolutePath());
            System.out.println("Output: " + file2.getAbsolutePath());
            PngCompressor.writeSizeMessage(n, byArray.length);
        }
        if (byArray.length < n) {
            if (verbose) {
                System.out.println("Writing compressed image");
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        } else if (!file.equals(file2)) {
            if (verbose) {
                System.out.println("Writing original image (compressed image is not smaller)");
            }
            PngCompressor.copyFile(file, file2);
        } else if (verbose) {
            System.out.println("Compressed image is not smaller, not overwriting");
        }
        if (verbose) {
            System.out.println();
        }
    }

    public static void compress(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage;
        byte[] byArray = PngCompressor.getByteArrayFromInputStream(inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            bufferedImage = ImageIO.read(byteArrayInputStream);
        }
        catch (IOException iOException) {
            System.out.println("error: Failed to read image");
            throw new IOException(iOException);
        }
        if (bufferedImage == null) {
            throw new IOException("error: Failed to read image");
        }
        byte[] byArray2 = PngCompressor.getCompressedImageAsByteArray(bufferedImage, byArray.length);
        if (verbose) {
            PngCompressor.writeSizeMessage(byArray.length, byArray2.length);
        }
        if (byArray2.length < byArray.length) {
            if (verbose) {
                System.out.println("Returning compressed image");
            }
            outputStream.write(byArray2);
        } else {
            if (verbose) {
                System.out.println("Returning original image (compressed image is not smaller)");
            }
            outputStream.write(byArray);
        }
        if (verbose) {
            System.out.println();
        }
    }

    private static byte[] getByteArrayFromInputStream(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static boolean processFile(File file, boolean bl) {
        String string = file.getAbsolutePath();
        if (file.exists()) {
            if (string.toLowerCase().endsWith(".png")) {
                File file2;
                if (bl) {
                    file2 = file;
                } else {
                    int n = string.length() - 4;
                    file2 = new File(string.substring(0, n) + FILENAME + string.substring(n));
                }
                try {
                    PngCompressor.compress(file, file2);
                    return true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return false;
                }
            }
            System.out.println("error: " + string + " is not a png file.");
            return false;
        }
        System.out.println("error: " + string + " does not exist.");
        return false;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            PngCompressor.showCommandLineHelp();
        } else {
            boolean bl = false;
            verbose = "true".equalsIgnoreCase(System.getProperty("verbose"));
            boolean bl2 = "true".equalsIgnoreCase(System.getProperty("overwrite"));
            for (String string : stringArray) {
                boolean bl3 = PngCompressor.processFile(new File(string), bl2);
                if (bl3) continue;
                bl = true;
            }
            if (bl) {
                System.exit(1);
            }
        }
    }

    private static void showCommandLineHelp() {
        System.out.println("How to run PngCompressor:\n\n    java [options] -jar jdeli.jar compresspng [pngfile [pngfile ...]]\n\n        options:\n            1. -Doverwrite=true       overwrite input files (default: \"false\")\n            2. -Dverbose=true         print status messages (default: \"false\")\n\n    Examples:\n        java -jar jdeli.jar compresspng file.png\n\n        java -Doverwrite=true -jar jdeli.jar compresspng /directory/*.png\n\n        java -Dverbose=true -jar jdeli.jar compresspng /directory/*.png\n\n    The output filename is the same as the input name except that _compressed\n    will be appended to the name. E.g. file.png will become file_compressed.png\n    This can be changed to overwrite the existing file by setting the overwrite\n    setting to true.");
    }
}

