/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class JpegEncoder {
    private int quality = 50;
    private static final int[] QL = new int[]{16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99};
    private static final int[] QC = new int[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
    private static final int[] ZIGZAG = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
    private static final int[] CODESDCL = new int[]{0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] SYMBOLSDCL = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] CODESACL = new int[]{0, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125};
    private static final int[] SYMBOLSACL = new int[]{1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, 129, 145, 161, 8, 35, 66, 177, 193, 21, 82, 209, 240, 36, 51, 98, 114, 130, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250};
    private static final int[] CODESDCC = new int[]{0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final int[] SYMBOLSDCC = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] CODESACC = new int[]{0, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119};
    private static final int[] SYMBOLSACC = new int[]{0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, 129, 8, 20, 66, 145, 161, 177, 193, 9, 35, 51, 82, 240, 21, 98, 114, 209, 10, 22, 36, 52, 225, 37, 241, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 130, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 226, 227, 228, 229, 230, 231, 232, 233, 234, 242, 243, 244, 245, 246, 247, 248, 249, 250};
    private final int[] TL = new int[64];
    private final int[] TC = new int[64];
    private final float[] FDL = new float[64];
    private final float[] FDC = new float[64];
    private final int[] DU = new int[64];
    private final int[][] DCHTL = new int[4096][2];
    private final int[][] DCHTC = new int[4096][2];
    private final int[][] ACHTL = new int[4096][2];
    private final int[][] ACHTC = new int[4096][2];
    private final int[][] codes = new int[65535][2];
    private final int[] items = new int[65535];
    ByteArrayOutputStream bos;
    private int buffer;
    private int pointer = 7;
    private byte[] pixelBytes;
    private int[] pixelInts;

    public void write(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        this.updatePixelHolder(bufferedImage);
        this.encode(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        outputStream.write(this.bos.toByteArray());
    }

    public void setQuality(int n) {
        this.quality = n;
    }

    public int getQuality() {
        return this.quality;
    }

    private void generateQTables(float f) {
        int n;
        int n2;
        for (n2 = 0; n2 < 64; ++n2) {
            n = (int)(((float)QL[n2] * f + 50.0f) / 100.0f);
            this.TL[JpegEncoder.ZIGZAG[n2]] = n < 1 ? 1 : (n > 255 ? 255 : n);
        }
        for (n2 = 0; n2 < 64; ++n2) {
            n = (int)(((float)QC[n2] * f + 50.0f) / 100.0f);
            this.TC[JpegEncoder.ZIGZAG[n2]] = n < 1 ? 1 : (n > 255 ? 255 : n);
        }
        float[] fArray = new float[]{1.0f, 1.3870399f, 1.306563f, 1.1758755f, 1.0f, 0.78569496f, 0.5411961f, 0.27589938f};
        n = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.FDL[n] = (float)(1.0 / ((double)((float)this.TL[ZIGZAG[n]] * fArray[i] * fArray[j]) * 8.0));
                this.FDC[n] = (float)(1.0 / ((double)((float)this.TC[ZIGZAG[n]] * fArray[i] * fArray[j]) * 8.0));
                ++n;
            }
        }
    }

    private static void generateHuffmanMapping(int[][] nArray, int[] nArray2, int[] nArray3) {
        int n = 0;
        int n2 = 0;
        for (int i = 1; i <= 16; ++i) {
            for (int j = 1; j <= nArray2[i]; ++j) {
                nArray[nArray3[n2]][0] = n++;
                nArray[nArray3[n2]][1] = i;
                ++n2;
            }
            n *= 2;
        }
    }

    private void generateHuffmanItems() {
        int n = 1;
        int n2 = 2;
        for (int i = 1; i <= 15; ++i) {
            int n3;
            for (n3 = n; n3 < n2; ++n3) {
                this.items[Short.MAX_VALUE + n3] = i;
                this.codes[Short.MAX_VALUE + n3][1] = i;
                this.codes[Short.MAX_VALUE + n3][0] = n3;
            }
            for (n3 = -(n2 - 1); n3 <= -n; ++n3) {
                this.items[Short.MAX_VALUE + n3] = i;
                this.codes[Short.MAX_VALUE + n3][1] = i;
                this.codes[Short.MAX_VALUE + n3][0] = n2 - 1 + n3;
            }
            n <<= 1;
            n2 <<= 1;
        }
    }

    private void putHuffBits(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1] - 1;
        while (n2 >= 0) {
            if ((n & 1 << n2) != 0) {
                this.buffer |= 1 << this.pointer;
            }
            --n2;
            --this.pointer;
            if (this.pointer >= 0) continue;
            if (this.buffer == 255) {
                this.putByte(255);
                this.putByte(0);
            } else {
                this.putByte(this.buffer);
            }
            this.pointer = 7;
            this.buffer = 0;
        }
    }

    private void putByte(int n) {
        this.bos.write(n);
    }

    private void putChar(int n) {
        this.putByte(n >> 8 & 0xFF);
        this.putByte(n & 0xFF);
    }

    private static int[] fDCTQuant(float[] fArray, float[] fArray2, int[] nArray) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        float f19;
        float f20;
        int n;
        int n2 = 0;
        for (n = 0; n < 8; ++n) {
            f20 = fArray[n2];
            f19 = fArray[n2 + 1];
            f18 = fArray[n2 + 2];
            f17 = fArray[n2 + 3];
            f16 = fArray[n2 + 4];
            f15 = fArray[n2 + 5];
            f14 = fArray[n2 + 6];
            f13 = fArray[n2 + 7];
            f12 = f20 + f13;
            f11 = f20 - f13;
            f10 = f19 + f14;
            f9 = f19 - f14;
            f8 = f18 + f15;
            f7 = f18 - f15;
            f6 = f17 + f16;
            f5 = f17 - f16;
            f4 = f12 + f6;
            f3 = f12 - f6;
            f2 = f10 + f8;
            f = f10 - f8;
            fArray[n2] = f4 + f2;
            fArray[n2 + 4] = f4 - f2;
            f19 = (f + f3) * 0.70710677f;
            fArray[n2 + 2] = f3 + f19;
            fArray[n2 + 6] = f3 - f19;
            f4 = f5 + f7;
            f2 = f7 + f9;
            f = f9 + f11;
            f15 = (f4 - f) * 0.38268343f;
            f18 = 0.5411961f * f4 + f15;
            f16 = 1.306563f * f + f15;
            f17 = f2 * 0.70710677f;
            f14 = f11 + f17;
            f13 = f11 - f17;
            fArray[n2 + 5] = f13 + f18;
            fArray[n2 + 3] = f13 - f18;
            fArray[n2 + 1] = f14 + f16;
            fArray[n2 + 7] = f14 - f16;
            n2 += 8;
        }
        n2 = 0;
        for (n = 0; n < 8; ++n) {
            f20 = fArray[n2];
            f19 = fArray[n2 + 8];
            f18 = fArray[n2 + 16];
            f17 = fArray[n2 + 24];
            f16 = fArray[n2 + 32];
            f15 = fArray[n2 + 40];
            f14 = fArray[n2 + 48];
            f13 = fArray[n2 + 56];
            f12 = f20 + f13;
            f11 = f20 - f13;
            f10 = f19 + f14;
            f9 = f19 - f14;
            f8 = f18 + f15;
            f7 = f18 - f15;
            f6 = f17 + f16;
            f5 = f17 - f16;
            f4 = f12 + f6;
            f3 = f12 - f6;
            f2 = f10 + f8;
            f = f10 - f8;
            fArray[n2] = f4 + f2;
            fArray[n2 + 32] = f4 - f2;
            f19 = (f + f3) * 0.70710677f;
            f4 = f5 + f7;
            f2 = f7 + f9;
            f = f9 + f11;
            f15 = (f4 - f) * 0.38268343f;
            f18 = 0.5411961f * f4 + f15;
            f16 = 1.306563f * f + f15;
            f17 = f2 * 0.70710677f;
            f14 = f11 + f17;
            f13 = f11 - f17;
            fArray[n2 + 16] = f3 + f19;
            fArray[n2 + 48] = f3 - f19;
            fArray[n2 + 40] = f13 + f18;
            fArray[n2 + 24] = f13 - f18;
            fArray[n2 + 8] = f14 + f16;
            fArray[n2 + 56] = f14 - f16;
            ++n2;
        }
        for (n = 0; n < 64; ++n) {
            float f21 = fArray[n] * fArray2[n];
            nArray[n] = (int)((double)f21 > 0.0 ? (double)f21 + 0.5 : (double)f21 - 0.5);
        }
        return nArray;
    }

    private void writeAPP0() {
        this.putChar(65504);
        this.putChar(16);
        this.putByte(74);
        this.putByte(70);
        this.putByte(73);
        this.putByte(70);
        this.putByte(0);
        this.putByte(1);
        this.putByte(1);
        this.putByte(0);
        this.putChar(1);
        this.putChar(1);
        this.putByte(0);
        this.putByte(0);
    }

    private void writeSOF0(int n, int n2) {
        this.putChar(65472);
        this.putChar(17);
        this.putByte(8);
        this.putChar(n2);
        this.putChar(n);
        this.putByte(3);
        this.putByte(1);
        this.putByte(17);
        this.putByte(0);
        this.putByte(2);
        this.putByte(17);
        this.putByte(1);
        this.putByte(3);
        this.putByte(17);
        this.putByte(1);
    }

    private void writeSOS() {
        this.putChar(65498);
        this.putChar(12);
        this.putByte(3);
        this.putByte(1);
        this.putByte(0);
        this.putByte(2);
        this.putByte(17);
        this.putByte(3);
        this.putByte(17);
        this.putByte(0);
        this.putByte(63);
        this.putByte(0);
    }

    private void writeDQT() {
        int n;
        this.putChar(65499);
        this.putChar(132);
        this.putByte(0);
        for (n = 0; n < 64; ++n) {
            this.putByte(this.TL[n]);
        }
        this.putByte(1);
        for (n = 0; n < 64; ++n) {
            this.putByte(this.TC[n]);
        }
    }

    private void writeDHT() {
        int n;
        int n2;
        this.putChar(65476);
        this.putChar(418);
        this.putByte(0);
        for (n2 = 0; n2 < 16; ++n2) {
            this.putByte(CODESDCL[n2 + 1]);
        }
        for (n2 = 0; n2 <= 11; ++n2) {
            this.putByte(SYMBOLSDCL[n2]);
        }
        this.putByte(16);
        for (n2 = 0; n2 < 16; ++n2) {
            this.putByte(CODESACL[n2 + 1]);
        }
        for (n2 = 0; n2 <= 161; ++n2) {
            this.putByte(SYMBOLSACL[n2]);
        }
        this.putByte(1);
        for (n2 = 0; n2 < 16; ++n2) {
            this.putByte(CODESDCC[n2 + 1]);
        }
        for (n2 = 0; n2 <= 11; ++n2) {
            this.putByte(SYMBOLSDCC[n2]);
        }
        this.putByte(17);
        for (n = 0; n < 16; ++n) {
            this.putByte(CODESACC[n + 1]);
        }
        for (n = 0; n <= 161; ++n) {
            this.putByte(SYMBOLSACC[n]);
        }
    }

    private int compress(float[] fArray, float[] fArray2, int n, int[][] nArray, int[][] nArray2, int[] nArray3) {
        int n2;
        int n3;
        int n4;
        int[] nArray4 = nArray2[0];
        int[] nArray5 = nArray2[240];
        int[] nArray6 = JpegEncoder.fDCTQuant(fArray, fArray2, nArray3);
        for (n4 = 0; n4 < 64; ++n4) {
            this.DU[JpegEncoder.ZIGZAG[n4]] = nArray6[n4];
        }
        n4 = this.DU[0] - n;
        n = this.DU[0];
        if (n4 == 0) {
            this.putHuffBits(nArray[0]);
        } else {
            n3 = Short.MAX_VALUE + n4;
            this.putHuffBits(nArray[this.items[n3]]);
            this.putHuffBits(this.codes[n3]);
        }
        for (n2 = 63; n2 > 0 && this.DU[n2] == 0; --n2) {
        }
        if (n2 == 0) {
            this.putHuffBits(nArray4);
            return n;
        }
        for (int i = 1; i <= n2; ++i) {
            int n5 = i;
            while (this.DU[i] == 0 && i <= n2) {
                ++i;
            }
            int n6 = i - n5;
            if (n6 >= 16) {
                int n7 = n6 >> 4;
                for (int j = 1; j <= n7; ++j) {
                    this.putHuffBits(nArray5);
                }
                n6 &= 0xF;
            }
            n3 = Short.MAX_VALUE + this.DU[i];
            this.putHuffBits(nArray2[(n6 << 4) + this.items[n3]]);
            this.putHuffBits(this.codes[n3]);
        }
        if (n2 != 63) {
            this.putHuffBits(nArray4);
        }
        return n;
    }

    private void encode(int n, int n2, int n3) throws IOException {
        this.bos = new ByteArrayOutputStream();
        this.quality = this.quality <= 0 ? 1 : (this.quality > 100 ? 100 : this.quality);
        int n4 = this.quality < 50 ? 5000 / this.quality : 200 - (this.quality << 1);
        this.generateQTables(n4);
        JpegEncoder.generateHuffmanMapping(this.DCHTL, CODESDCL, SYMBOLSDCL);
        JpegEncoder.generateHuffmanMapping(this.DCHTC, CODESDCC, SYMBOLSDCC);
        JpegEncoder.generateHuffmanMapping(this.ACHTL, CODESACL, SYMBOLSACL);
        JpegEncoder.generateHuffmanMapping(this.ACHTC, CODESACC, SYMBOLSACC);
        this.generateHuffmanItems();
        this.buffer = 0;
        this.pointer = 7;
        this.putChar(65496);
        this.writeAPP0();
        this.writeDQT();
        this.writeSOF0(n, n2);
        this.writeDHT();
        this.writeSOS();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        this.buffer = 0;
        this.pointer = 7;
        float[] fArray = new float[64];
        float[] fArray2 = new float[64];
        float[] fArray3 = new float[64];
        int[] nArray = new int[64];
        int n8 = n * n2;
        for (int i = 0; i < n2; i += 8) {
            for (int j = 0; j < n; j += 8) {
                int n9 = n * i + j;
                for (int k = 0; k < 64; ++k) {
                    int n10 = k >> 3;
                    int n11 = k & 7;
                    int n12 = n9 + n10 * n + n11;
                    if (i + n10 >= n2) {
                        n12 -= n * (i + 1 + n10 - n2);
                    }
                    if (j + n11 >= n) {
                        n12 -= j + n11 - n + 4;
                    }
                    if (n12 > n8 || n12 < 0) continue;
                    int[] nArray2 = this.getPixel(n12, n3);
                    int n13 = nArray2[0];
                    int n14 = nArray2[1];
                    int n15 = nArray2[2];
                    fArray[k] = (128 + 76 * n13 + 150 * n14 + 29 * n15 >> 8) - 128;
                    fArray2[k] = 128 + 127 * n15 - 84 * n14 - 43 * n13 >> 8;
                    fArray3[k] = 128 + 127 * n13 - 106 * n14 - 21 * n15 >> 8;
                }
                n5 = this.compress(fArray, this.FDL, n5, this.DCHTL, this.ACHTL, nArray);
                n6 = this.compress(fArray2, this.FDC, n6, this.DCHTC, this.ACHTC, nArray);
                n7 = this.compress(fArray3, this.FDC, n7, this.DCHTC, this.ACHTC, nArray);
            }
        }
        if (this.pointer >= 0) {
            int[] nArray3 = new int[2];
            nArray3[1] = this.pointer + 1;
            nArray3[0] = (1 << this.pointer + 1) - 1;
            this.putHuffBits(nArray3);
        }
        this.putChar(65497);
        this.bos.close();
    }

    private void updatePixelHolder(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                this.pixelBytes = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.pixelInts = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                break;
            }
            default: {
                BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
                Graphics graphics = bufferedImage2.getGraphics();
                graphics.drawImage(bufferedImage, 0, 0, null);
                graphics.dispose();
                this.pixelInts = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
            }
        }
    }

    private int[] getPixel(int n, int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                int n3 = this.pixelInts[n];
                return new int[]{n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF};
            }
            case 4: {
                int n4 = this.pixelInts[n];
                return new int[]{n4 & 0xFF, n4 >> 8 & 0xFF, n4 >> 16 & 0xFF};
            }
            case 5: {
                int n5 = n * 3;
                int n6 = this.pixelBytes[n5] & 0xFF;
                int n7 = this.pixelBytes[n5 + 1] & 0xFF;
                int n8 = this.pixelBytes[n5 + 2] & 0xFF;
                return new int[]{n8, n7, n6};
            }
            case 6: 
            case 7: {
                int n9 = n * 4;
                int n10 = this.pixelBytes[n9 + 1] & 0xFF;
                int n11 = this.pixelBytes[n9 + 2] & 0xFF;
                int n12 = this.pixelBytes[n9 + 3] & 0xFF;
                return new int[]{n12, n11, n10};
            }
            case 10: {
                int n13 = this.pixelBytes[n] & 0xFF;
                return new int[]{n13, n13, n13};
            }
        }
        int n14 = this.pixelInts[n];
        return new int[]{n14 >> 16 & 0xFF, n14 >> 8 & 0xFF, n14 & 0xFF};
    }
}

