/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

public class Quant32 {
    private static final int IndexBits = 6;
    private static final int IndexBitsPlus = 7;
    private static final int DoubleIndexBits = 12;
    private static final int IndexAlphaBits = 3;
    private static final int SumBits = 9;
    private static final int IndexCount = 65;
    private static final int IndexAlphaCount = 9;
    private static final int TableLength = 2471625;
    private final long[] vwt = new long[2471625];
    private final long[] vmr = new long[2471625];
    private final long[] vmg = new long[2471625];
    private final long[] vmb = new long[2471625];
    private final long[] vma = new long[2471625];
    private final double[] m2 = new double[2471625];

    private static int indexify(int n, int n2, int n3, int n4) {
        return (n << 15) + (n << 10) + (n2 << 9) + (n << 12) + (n << 7) + (n2 << 6) + (n + n2 + n3 << 3) + n + n2 + n3 + n4;
    }

    private static double volume(Cube cube, long[] lArray) {
        return lArray[Quant32.indexify(cube.R1, cube.G1, cube.B1, cube.A1)] - lArray[Quant32.indexify(cube.R1, cube.G1, cube.B1, cube.A0)] - lArray[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A1)] + lArray[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A0)] - lArray[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A1)] + lArray[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A0)] + lArray[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A1)] - lArray[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A0)] - lArray[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A1)] + lArray[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A0)] + lArray[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A1)] - lArray[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A0)] + lArray[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A1)] - lArray[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A0)] - lArray[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A1)] + lArray[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
    }

    private static long base(Cube cube, int n, long[] lArray) {
        switch (n) {
            case 3: {
                return -lArray[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A1)] + lArray[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A0)] + lArray[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A1)] - lArray[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A0)] + lArray[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A1)] - lArray[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A0)] - lArray[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A1)] + lArray[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
            }
            case 2: {
                return -lArray[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A1)] + lArray[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A0)] + lArray[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A1)] - lArray[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A0)] + lArray[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A1)] - lArray[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A0)] - lArray[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A1)] + lArray[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
            }
            case 1: {
                return -lArray[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A1)] + lArray[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A0)] + lArray[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A1)] - lArray[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A0)] + lArray[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A1)] - lArray[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A0)] - lArray[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A1)] + lArray[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
            }
            case 0: {
                return -lArray[Quant32.indexify(cube.R1, cube.G1, cube.B1, cube.A0)] + lArray[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A0)] + lArray[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A0)] - lArray[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A0)] + lArray[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A0)] - lArray[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A0)] - lArray[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A0)] + lArray[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
            }
        }
        return 0L;
    }

    private static long findTop(Cube cube, int n, int n2, long[] lArray) {
        switch (n) {
            case 3: {
                return lArray[Quant32.indexify(n2, cube.G1, cube.B1, cube.A1)] - lArray[Quant32.indexify(n2, cube.G1, cube.B1, cube.A0)] - lArray[Quant32.indexify(n2, cube.G1, cube.B0, cube.A1)] + lArray[Quant32.indexify(n2, cube.G1, cube.B0, cube.A0)] - lArray[Quant32.indexify(n2, cube.G0, cube.B1, cube.A1)] + lArray[Quant32.indexify(n2, cube.G0, cube.B1, cube.A0)] + lArray[Quant32.indexify(n2, cube.G0, cube.B0, cube.A1)] - lArray[Quant32.indexify(n2, cube.G0, cube.B0, cube.A0)];
            }
            case 2: {
                return lArray[Quant32.indexify(cube.R1, n2, cube.B1, cube.A1)] - lArray[Quant32.indexify(cube.R1, n2, cube.B1, cube.A0)] - lArray[Quant32.indexify(cube.R1, n2, cube.B0, cube.A1)] + lArray[Quant32.indexify(cube.R1, n2, cube.B0, cube.A0)] - lArray[Quant32.indexify(cube.R0, n2, cube.B1, cube.A1)] + lArray[Quant32.indexify(cube.R0, n2, cube.B1, cube.A0)] + lArray[Quant32.indexify(cube.R0, n2, cube.B0, cube.A1)] - lArray[Quant32.indexify(cube.R0, n2, cube.B0, cube.A0)];
            }
            case 1: {
                return lArray[Quant32.indexify(cube.R1, cube.G1, n2, cube.A1)] - lArray[Quant32.indexify(cube.R1, cube.G1, n2, cube.A0)] - lArray[Quant32.indexify(cube.R1, cube.G0, n2, cube.A1)] + lArray[Quant32.indexify(cube.R1, cube.G0, n2, cube.A0)] - lArray[Quant32.indexify(cube.R0, cube.G1, n2, cube.A1)] + lArray[Quant32.indexify(cube.R0, cube.G1, n2, cube.A0)] + lArray[Quant32.indexify(cube.R0, cube.G0, n2, cube.A1)] - lArray[Quant32.indexify(cube.R0, cube.G0, n2, cube.A0)];
            }
            case 0: {
                return lArray[Quant32.indexify(cube.R1, cube.G1, cube.B1, n2)] - lArray[Quant32.indexify(cube.R1, cube.G1, cube.B0, n2)] - lArray[Quant32.indexify(cube.R1, cube.G0, cube.B1, n2)] + lArray[Quant32.indexify(cube.R1, cube.G0, cube.B0, n2)] - lArray[Quant32.indexify(cube.R0, cube.G1, cube.B1, n2)] + lArray[Quant32.indexify(cube.R0, cube.G1, cube.B0, n2)] + lArray[Quant32.indexify(cube.R0, cube.G0, cube.B1, n2)] - lArray[Quant32.indexify(cube.R0, cube.G0, cube.B0, n2)];
            }
        }
        return 0L;
    }

    private void histogram(int[][] nArray) {
        int n = 2;
        int n2 = 5;
        int n3 = nArray.length;
        int n4 = nArray[0].length;
        for (int i = 0; i < n3; ++i) {
            int[] nArray2 = nArray[i];
            for (int j = 0; j < n4; ++j) {
                int n5;
                int n6 = nArray2[j];
                int n7 = n6 >> 24 & 0xFF;
                int n8 = n6 >> 16 & 0xFF;
                int n9 = n6 >> 8 & 0xFF;
                int n10 = n6 & 0xFF;
                int n11 = n8 >> n;
                int n12 = n9 >> n;
                int n13 = n10 >> n;
                int n14 = n7 >> n2;
                int n15 = n5 = Quant32.indexify(n11 + 1, n12 + 1, n13 + 1, n14 + 1);
                this.vwt[n15] = this.vwt[n15] + 1L;
                int n16 = n5;
                this.vmr[n16] = this.vmr[n16] + (long)n8;
                int n17 = n5;
                this.vmg[n17] = this.vmg[n17] + (long)n9;
                int n18 = n5;
                this.vmb[n18] = this.vmb[n18] + (long)n10;
                int n19 = n5;
                this.vma[n19] = this.vma[n19] + (long)n7;
                int n20 = n5;
                this.m2[n20] = this.m2[n20] + (double)(n8 * n8 + n9 * n9 + n10 * n10 + n7 * n7);
            }
        }
    }

    private void M3d() {
        int n = 585;
        for (int i = 1; i < 65; ++i) {
            long[] lArray = new long[n];
            long[] lArray2 = new long[n];
            long[] lArray3 = new long[n];
            long[] lArray4 = new long[n];
            long[] lArray5 = new long[n];
            double[] dArray = new double[n];
            for (int j = 1; j < 65; ++j) {
                long[] lArray6 = new long[9];
                long[] lArray7 = new long[9];
                long[] lArray8 = new long[9];
                long[] lArray9 = new long[9];
                long[] lArray10 = new long[9];
                double[] dArray2 = new double[9];
                for (int k = 1; k < 65; ++k) {
                    long l = 0L;
                    long l2 = 0L;
                    long l3 = 0L;
                    long l4 = 0L;
                    long l5 = 0L;
                    double d = 0.0;
                    for (int i2 = 1; i2 < 9; ++i2) {
                        int n2;
                        int n3 = Quant32.indexify(i, j, k, i2);
                        l += this.vwt[n3];
                        l2 += this.vmr[n3];
                        l3 += this.vmg[n3];
                        l4 += this.vmb[n3];
                        l5 += this.vma[n3];
                        d += this.m2[n3];
                        int n4 = i2;
                        lArray6[n4] = lArray6[n4] + l;
                        int n5 = i2;
                        lArray7[n5] = lArray7[n5] + l2;
                        int n6 = i2;
                        lArray8[n6] = lArray8[n6] + l3;
                        int n7 = i2;
                        lArray9[n7] = lArray9[n7] + l4;
                        int n8 = i2;
                        lArray10[n8] = lArray10[n8] + l5;
                        int n9 = i2;
                        dArray2[n9] = dArray2[n9] + d;
                        int n10 = n2 = k * 9 + i2;
                        lArray[n10] = lArray[n10] + lArray6[i2];
                        int n11 = n2;
                        lArray2[n11] = lArray2[n11] + lArray7[i2];
                        int n12 = n2;
                        lArray3[n12] = lArray3[n12] + lArray8[i2];
                        int n13 = n2;
                        lArray4[n13] = lArray4[n13] + lArray9[i2];
                        int n14 = n2;
                        lArray5[n14] = lArray5[n14] + lArray10[i2];
                        int n15 = n2;
                        dArray[n15] = dArray[n15] + dArray2[i2];
                        int n16 = n3 - Quant32.indexify(1, 0, 0, 0);
                        this.vwt[n3] = this.vwt[n16] + lArray[n2];
                        this.vmr[n3] = this.vmr[n16] + lArray2[n2];
                        this.vmg[n3] = this.vmg[n16] + lArray3[n2];
                        this.vmb[n3] = this.vmb[n16] + lArray4[n2];
                        this.vma[n3] = this.vma[n16] + lArray5[n2];
                        this.m2[n3] = this.m2[n16] + dArray[n2];
                    }
                }
            }
        }
    }

    private double variance(Cube cube) {
        double d = Quant32.volume(cube, this.vmr);
        double d2 = Quant32.volume(cube, this.vmg);
        double d3 = Quant32.volume(cube, this.vmb);
        double d4 = Quant32.volume(cube, this.vma);
        double d5 = this.m2[Quant32.indexify(cube.R1, cube.G1, cube.B1, cube.A1)] - this.m2[Quant32.indexify(cube.R1, cube.G1, cube.B1, cube.A0)] - this.m2[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A1)] + this.m2[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A0)] - this.m2[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A1)] + this.m2[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A0)] + this.m2[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A1)] - this.m2[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A0)] - this.m2[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A1)] + this.m2[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A0)] + this.m2[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A1)] - this.m2[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A0)] + this.m2[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A1)] - this.m2[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A0)] - this.m2[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A1)] + this.m2[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
        return d5 - (d * d + d2 * d2 + d3 * d3 + d4 * d4) / Quant32.volume(cube, this.vwt);
    }

    private Object[] maximize(Cube cube, int n, int n2, int n3, double d, double d2, double d3, double d4, double d5) {
        long l = Quant32.base(cube, n, this.vmr);
        long l2 = Quant32.base(cube, n, this.vmg);
        long l3 = Quant32.base(cube, n, this.vmb);
        long l4 = Quant32.base(cube, n, this.vma);
        long l5 = Quant32.base(cube, n, this.vwt);
        double d6 = 0.0;
        int n4 = -1;
        for (int i = n2; i < n3; ++i) {
            double d7 = l + Quant32.findTop(cube, n, i, this.vmr);
            double d8 = l2 + Quant32.findTop(cube, n, i, this.vmg);
            double d9 = l3 + Quant32.findTop(cube, n, i, this.vmb);
            double d10 = l4 + Quant32.findTop(cube, n, i, this.vma);
            double d11 = l5 + Quant32.findTop(cube, n, i, this.vwt);
            if (d11 == 0.0) continue;
            double d12 = (d7 * d7 + d8 * d8 + d9 * d9 + d10 * d10) / d11;
            d7 = d - d7;
            d8 = d2 - d8;
            d9 = d3 - d9;
            d10 = d4 - d10;
            if ((d11 = d5 - d11) == 0.0 || !((d12 += (d7 * d7 + d8 * d8 + d9 * d9 + d10 * d10) / d11) > d6)) continue;
            d6 = d12;
            n4 = i;
        }
        return new Object[]{n4, d6};
    }

    private boolean cut(Cube cube, Cube cube2) {
        int n;
        double d = Quant32.volume(cube, this.vmr);
        double d2 = Quant32.volume(cube, this.vmg);
        double d3 = Quant32.volume(cube, this.vmb);
        double d4 = Quant32.volume(cube, this.vma);
        double d5 = Quant32.volume(cube, this.vwt);
        Object[] objectArray = this.maximize(cube, 3, cube.R0 + 1, cube.R1, d, d2, d3, d4, d5);
        int n2 = (Integer)objectArray[0];
        double d6 = (Double)objectArray[1];
        objectArray = this.maximize(cube, 2, cube.G0 + 1, cube.G1, d, d2, d3, d4, d5);
        int n3 = (Integer)objectArray[0];
        double d7 = (Double)objectArray[1];
        objectArray = this.maximize(cube, 1, cube.B0 + 1, cube.B1, d, d2, d3, d4, d5);
        int n4 = (Integer)objectArray[0];
        double d8 = (Double)objectArray[1];
        objectArray = this.maximize(cube, 0, cube.A0 + 1, cube.A1, d, d2, d3, d4, d5);
        int n5 = (Integer)objectArray[0];
        double d9 = (Double)objectArray[1];
        if (d6 >= d7 && d6 >= d8 && d6 >= d9) {
            n = 3;
            if (n2 < 0) {
                return false;
            }
        } else {
            n = d7 >= d6 && d7 >= d8 && d7 >= d9 ? 2 : (d8 >= d6 && d8 >= d7 && d8 >= d9 ? 1 : 0);
        }
        cube2.R1 = cube.R1;
        cube2.G1 = cube.G1;
        cube2.B1 = cube.B1;
        cube2.A1 = cube.A1;
        switch (n) {
            case 3: {
                cube2.R0 = cube.R1 = n2;
                cube2.G0 = cube.G0;
                cube2.B0 = cube.B0;
                cube2.A0 = cube.A0;
                break;
            }
            case 2: {
                cube2.G0 = cube.G1 = n3;
                cube2.R0 = cube.R0;
                cube2.B0 = cube.B0;
                cube2.A0 = cube.A0;
                break;
            }
            case 1: {
                cube2.B0 = cube.B1 = n4;
                cube2.R0 = cube.R0;
                cube2.G0 = cube.G0;
                cube2.A0 = cube.A0;
                break;
            }
            case 0: {
                cube2.A0 = cube.A1 = n5;
                cube2.R0 = cube.R0;
                cube2.G0 = cube.G0;
                cube2.B0 = cube.B0;
            }
        }
        cube.Volume = (cube.R1 - cube.R0) * (cube.G1 - cube.G0) * (cube.B1 - cube.B0) * (cube.A1 - cube.A0);
        cube2.Volume = (cube2.R1 - cube2.R0) * (cube2.G1 - cube2.G0) * (cube2.B1 - cube2.B0) * (cube2.A1 - cube2.A0);
        return true;
    }

    private void buildCube(Cube[] cubeArray, int n) {
        int n2;
        double[] dArray = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            cubeArray[n2] = new Cube();
        }
        cubeArray[0].A0 = 0;
        cubeArray[0].B0 = 0;
        cubeArray[0].G0 = 0;
        cubeArray[0].R0 = 0;
        cubeArray[0].B1 = 64;
        cubeArray[0].G1 = 64;
        cubeArray[0].R1 = 64;
        cubeArray[0].A1 = 8;
        n2 = 0;
        for (int i = 1; i < n; ++i) {
            if (this.cut(cubeArray[n2], cubeArray[i])) {
                dArray[n2] = cubeArray[n2].Volume > 1 ? this.variance(cubeArray[n2]) : 0.0;
                dArray[i] = cubeArray[i].Volume > 1 ? this.variance(cubeArray[i]) : 0.0;
            } else {
                dArray[n2] = 0.0;
                --i;
            }
            n2 = 0;
            double d = dArray[0];
            for (int j = 1; j <= i; ++j) {
                if (!(dArray[j] > d)) continue;
                d = dArray[j];
                n2 = j;
            }
            if (d <= 0.0) break;
        }
    }

    public Object[] getPalette(int[][] nArray) {
        int n = 256;
        this.histogram(nArray);
        this.M3d();
        Cube[] cubeArray = new Cube[n];
        this.buildCube(cubeArray, n);
        byte[] byArray = new byte[768];
        byte[] byArray2 = new byte[256];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d = Quant32.volume(cubeArray[i], this.vwt);
            if (d != 0.0) {
                byArray2[i] = (byte)(Quant32.volume(cubeArray[i], this.vma) / d);
                byArray[n2++] = (byte)(Quant32.volume(cubeArray[i], this.vmr) / d);
                byArray[n2++] = (byte)(Quant32.volume(cubeArray[i], this.vmg) / d);
                byArray[n2++] = (byte)(Quant32.volume(cubeArray[i], this.vmb) / d);
                continue;
            }
            n2 += 4;
        }
        return new Object[]{byArray, byArray2};
    }

    static class Cube {
        int A0;
        int A1;
        int R0;
        int R1;
        int G0;
        int G1;
        int B0;
        int B1;
        int Volume;

        Cube() {
        }
    }
}

