/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.scale;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;

public class QualityThumbnail {
    public static BufferedImage getScaledImage(BufferedImage bufferedImage, int n, int n2) throws Exception {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        ColorModel colorModel = bufferedImage.getColorModel();
        int n5 = colorModel.getNumComponents();
        if (n == n3 && n2 == n4) {
            return bufferedImage;
        }
        if (n > n3 || n2 > n3 || colorModel instanceof IndexColorModel || bufferedImage.getType() == 0) {
            return QualityThumbnail.getCubicScaled(bufferedImage, n, n2);
        }
        int[] nArray = QualityThumbnail.getPixels(bufferedImage);
        nArray = QualityThumbnail.getLancsozPixels(nArray, n3, n4, n, n2, n5);
        return QualityThumbnail.getImageFromPixels(nArray, n, n2, bufferedImage.getType());
    }

    private static BufferedImage getImageFromPixels(int[] nArray, int n, int n2, int n3) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        int n4 = n * n2;
        int n5 = 0;
        switch (n3) {
            case 10: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n4; ++i) {
                    byArray[i] = (byte)nArray[i];
                }
                break;
            }
            case 5: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n4; ++i) {
                    int n6 = nArray[i];
                    byArray[n5++] = (byte)(n6 & 0xFF);
                    byArray[n5++] = (byte)(n6 >> 8 & 0xFF);
                    byArray[n5++] = (byte)(n6 >> 16);
                }
                break;
            }
            case 6: 
            case 7: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n4; ++i) {
                    int n7 = nArray[i];
                    byArray[n5++] = (byte)(n7 >> 24);
                    byArray[n5++] = (byte)(n7 & 0xFF);
                    byArray[n5++] = (byte)(n7 >> 8 & 0xFF);
                    byArray[n5++] = (byte)(n7 >> 16 & 0xFF);
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                int[] nArray2 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                System.arraycopy(nArray, 0, nArray2, 0, n4);
            }
        }
        return bufferedImage;
    }

    private static int[] getPixels(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = n * n2;
        int[] nArray = new int[n3];
        int n4 = 0;
        switch (bufferedImage.getType()) {
            case 10: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = byArray[i] & 0xFF;
                }
                break;
            }
            case 5: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n3; ++i) {
                    int n5 = byArray[n4++] & 0xFF;
                    int n6 = byArray[n4++] & 0xFF;
                    int n7 = byArray[n4++] & 0xFF;
                    nArray[i] = n7 << 16 | n6 << 8 | n5;
                }
                break;
            }
            case 6: 
            case 7: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n3; ++i) {
                    int n8 = byArray[n4++] & 0xFF;
                    int n9 = byArray[n4++] & 0xFF;
                    int n10 = byArray[n4++] & 0xFF;
                    int n11 = byArray[n4++] & 0xFF;
                    nArray[i] = n8 << 24 | n11 << 16 | n10 << 8 | n9;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            }
        }
        return nArray;
    }

    private static int[] getLancsozPixels(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int[] nArray2;
        block10: {
            int n6;
            int n7;
            float f;
            WeightsBox weightsBox;
            double d;
            double d2;
            block11: {
                block9: {
                    d2 = (double)n3 * 1.0 / (double)n;
                    d = (double)n4 * 1.0 / (double)n2;
                    int n8 = 3;
                    weightsBox = QualityThumbnail.generateWeightsBox(Math.min(d2, d), n8);
                    f = weightsBox.sum;
                    int n9 = 0;
                    n7 = (n << 1) - 1;
                    n6 = (n2 << 1) - 1;
                    nArray2 = new int[n3 * n4];
                    if (n5 != 1) break block9;
                    for (int i = 0; i < n4; ++i) {
                        int n10 = (int)((double)i / d);
                        for (int j = 0; j < n3; ++j) {
                            float f2 = 0.0f;
                            int n11 = (int)((double)j / d2);
                            for (Weight weight : weightsBox.weights) {
                                int n12 = QualityThumbnail.getLP(nArray, n11 + weight.x, n10 + weight.y, n, n2, n7, n6);
                                f2 += (float)(n12 & 0xFF) * weight.g;
                            }
                            nArray2[n9++] = QualityThumbnail.getLC(f2, f);
                        }
                    }
                    break block10;
                }
                if (n5 != 3) break block11;
                for (int i = 0; i < n4; ++i) {
                    int n13 = (int)((double)i / d);
                    for (int j = 0; j < n3; ++j) {
                        float f3 = 0.0f;
                        float f4 = 0.0f;
                        float f5 = 0.0f;
                        int n14 = (int)((double)j / d2);
                        for (Weight weight : weightsBox.weights) {
                            int n15 = QualityThumbnail.getLP(nArray, n14 + weight.x, n13 + weight.y, n, n2, n7, n6);
                            f3 += (float)(n15 >> 16) * weight.g;
                            f5 += (float)(n15 >> 8 & 0xFF) * weight.g;
                            f4 += (float)(n15 & 0xFF) * weight.g;
                        }
                        nArray2[n9++] = QualityThumbnail.getLC(f3, f) << 16 | QualityThumbnail.getLC(f5, f) << 8 | QualityThumbnail.getLC(f4, f);
                    }
                }
                break block10;
            }
            if (n5 != 4) break block10;
            for (int i = 0; i < n4; ++i) {
                int n16 = (int)((double)i / d);
                for (int j = 0; j < n3; ++j) {
                    float f6 = 0.0f;
                    float f7 = 0.0f;
                    float f8 = 0.0f;
                    float f9 = 0.0f;
                    int n17 = (int)((double)j / d2);
                    for (Weight weight : weightsBox.weights) {
                        int n18 = QualityThumbnail.getLP(nArray, n17 + weight.x, n16 + weight.y, n, n2, n7, n6);
                        f9 += (float)(n18 >> 24) * weight.g;
                        f6 += (float)(n18 >> 16 & 0xFF) * weight.g;
                        f8 += (float)(n18 >> 8 & 0xFF) * weight.g;
                        f7 += (float)(n18 & 0xFF) * weight.g;
                    }
                    nArray2[n9++] = QualityThumbnail.getLC(f9, f) << 24 | QualityThumbnail.getLC(f6, f) << 16 | QualityThumbnail.getLC(f8, f) << 8 | QualityThumbnail.getLC(f7, f);
                }
            }
        }
        return nArray2;
    }

    private static BufferedImage getCubicScaled(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        double d = (double)n / (double)n3;
        double d2 = (double)n2 / (double)n4;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 3);
        return affineTransformOp.filter(bufferedImage, new BufferedImage(n, n2, bufferedImage.getType()));
    }

    private static double filterLancsoz(double d, int n) {
        if (d == 0.0) {
            return 1.0;
        }
        if (Math.abs(d) >= (double)n) {
            return 0.0;
        }
        double d2 = Math.PI * d;
        return Math.sin(d2) / Math.PI / d * (Math.sin(d2 / (double)n) / Math.PI / d * (double)n);
    }

    private static int getLP(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n >= n3) {
            n = n5 - n;
        }
        if (n2 >= n4) {
            n2 = n6 - n2;
        }
        return nArray[n2 * n3 + n];
    }

    private static int getLC(float f, float f2) {
        if (f2 != 0.0f) {
            f /= f2;
        }
        return f < 0.0f ? 0 : (f > 255.0f ? 255 : (int)f);
    }

    private static WeightsBox generateWeightsBox(double d, int n) {
        double d2 = 0.5;
        double d3 = 0.5;
        int n2 = (int)((d2 - (double)n) / d);
        int n3 = (int)((d2 + (double)n) / d);
        float f = 0.0f;
        int n4 = n3 - n2;
        ArrayList<Weight> arrayList = new ArrayList<Weight>(n4 * n4);
        for (int i = n2; i <= n3; ++i) {
            double d4 = ((double)i + 0.5) * d - d3;
            double d5 = d4 * d4;
            for (int j = n2; j <= n3; ++j) {
                double d6 = ((double)j + 0.5) * d - d2;
                float f2 = (float)QualityThumbnail.filterLancsoz(Math.sqrt(d6 * d6 + d5), n);
                if (f2 == 0.0f) continue;
                arrayList.add(new Weight(j, i, f2));
                f += f2;
            }
        }
        return new WeightsBox(f, arrayList.toArray(new Weight[arrayList.size()]));
    }

    static class WeightsBox {
        public final float sum;
        public final Weight[] weights;

        public WeightsBox(float f, Weight[] weightArray) {
            this.sum = f;
            this.weights = weightArray;
        }
    }

    static class Weight {
        public final int x;
        public final int y;
        public final float g;

        public Weight(int n, int n2, float f) {
            this.x = n;
            this.y = n2;
            this.g = f;
        }
    }
}

