/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webm;

import com.idrsolutions.image.webm.BitDecoder;
import com.idrsolutions.image.webm.LittleReader;
import com.idrsolutions.image.webm.LookUp;
import com.idrsolutions.image.webm.MacroBlock;
import com.idrsolutions.image.webm.SegmentQuants;
import com.idrsolutions.image.webm.SubBlock;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Frame {
    private static final int BLOCK_TYPES = 4;
    private static final int COEF_BANDS = 8;
    private static final int MAX_ENTROPY_TOKENS = 12;
    private static final int MAX_MODE_LF_DELTAS = 4;
    private static final int MAX_REF_LF_DELTAS = 4;
    private static final int PREV_COEF_CONTEXTS = 3;
    private final int[][][][] coefProbs;
    private boolean debug;
    int filterLevel;
    int filterType;
    int frameType;
    private final LittleReader reader;
    private int height;
    private int mbCols;
    private int macroBlockNoCoeffSkip;
    private int mbRows;
    private MacroBlock[][] macroBlocks;
    private int macroBlockSegementAbsoluteDelta;
    private int[] macroBlockSegmentTreeProbs;
    private final int[] modeLoopFilterDeltas = new int[4];
    private int modeRefLoopFilterDeltaEnabled;
    private int modeRefLoopFilterDeltaUpdate;
    private int multiTokenPartition;
    private int offset;
    private final int[] refLoopFilterDeltas = new int[4];
    private int refreshEntropyProbs;
    private int segmentationIsEnabled;
    private SegmentQuants segmentQuants;
    private int sharpnessLevel;
    private int simpleFilter;
    private BitDecoder tokenBoolDecoder;
    private final List<BitDecoder> tokenBitDecoders;
    private int mBlockMap;
    private int mBlockData;
    private int width;

    public Frame(LittleReader littleReader) {
        this.reader = littleReader;
        this.offset = this.reader.getPosition();
        this.coefProbs = LookUp.getClonedDCP();
        this.tokenBitDecoders = new ArrayList<BitDecoder>();
    }

    private void createMacroBlocks() {
        this.macroBlocks = new MacroBlock[this.mbCols + 2][this.mbRows + 2];
        for (int i = 0; i < this.mbCols + 2; ++i) {
            for (int j = 0; j < this.mbRows + 2; ++j) {
                this.macroBlocks[i][j] = new MacroBlock(i, j, this.debug);
            }
        }
    }

    public boolean decodeFrame(boolean bl) throws IOException {
        int n;
        int n2;
        int n3;
        this.debug = bl;
        this.segmentQuants = new SegmentQuants();
        this.reader.seek(this.offset++);
        int n4 = this.reader.getUINT8();
        this.frameType = this.getBitAsInt(n4, 0);
        if (this.frameType != 0) {
            return false;
        }
        int n5 = this.getBitAsInt(n4, 1) << 1;
        n5 += this.getBitAsInt(n4, 2) << 1;
        n5 += this.getBitAsInt(n4, 3);
        this.getBit(n4, 4);
        int n6 = this.getBitAsInt(n4, 5);
        n6 += this.getBitAsInt(n4, 6) << 1;
        n6 += this.getBitAsInt(n4, 7) << 2;
        n4 = this.reader.getUINT8();
        n6 += n4 << 3;
        n4 = this.reader.getUINT8();
        n6 += n4 << 11;
        this.reader.getUINT8();
        this.reader.getUINT8();
        this.reader.getUINT8();
        n4 = this.reader.getUINT8();
        this.offset += 6;
        int n7 = n4;
        this.reader.seek(this.offset++);
        n4 = this.reader.getUINT8();
        this.width = (n7 += n4 << 8) & 0x3FFF;
        this.reader.seek(this.offset++);
        int n8 = n4 = this.reader.getUINT8();
        this.reader.seek(this.offset++);
        n4 = this.reader.getUINT8();
        this.height = (n8 += n4 << 8) & 0x3FFF;
        int n9 = this.width;
        int n10 = this.height;
        if ((n9 & 0xF) != 0) {
            n9 += 16 - (n9 & 0xF);
        }
        if ((n10 & 0xF) != 0) {
            n10 += 16 - (n10 & 0xF);
        }
        this.mbRows = n10 >> 4;
        this.mbCols = n9 >> 4;
        this.createMacroBlocks();
        BitDecoder bitDecoder = new BitDecoder(this.reader, this.offset);
        if (this.frameType == 0) {
            bitDecoder.getBit();
            bitDecoder.getBit();
        }
        this.segmentationIsEnabled = bitDecoder.getBit();
        if (this.segmentationIsEnabled > 0) {
            this.mBlockMap = bitDecoder.getBit();
            this.mBlockData = bitDecoder.getBit();
            if (this.mBlockData > 0) {
                this.macroBlockSegementAbsoluteDelta = bitDecoder.getBit();
                for (n3 = 0; n3 < 4; ++n3) {
                    n2 = 0;
                    if (bitDecoder.getBit() > 0) {
                        n2 = bitDecoder.getLiteral(LookUp.BITS_MACRO[0]);
                        if (bitDecoder.getBit() > 0) {
                            n2 = -n2;
                        }
                    }
                    this.segmentQuants.segQuants[n3].index = n2;
                }
                for (n3 = 0; n3 < 4; ++n3) {
                    n2 = 0;
                    if (bitDecoder.getBit() > 0) {
                        n2 = bitDecoder.getLiteral(LookUp.BITS_MACRO[1]);
                        if (bitDecoder.getBit() > 0) {
                            n2 = -n2;
                        }
                    }
                    this.segmentQuants.segQuants[n3].strength = n2;
                }
                if (this.mBlockMap > 0) {
                    this.macroBlockSegmentTreeProbs = new int[3];
                    for (n3 = 0; n3 < 3; ++n3) {
                        n2 = bitDecoder.getBit() > 0 ? bitDecoder.getLiteral(8) : 255;
                        this.macroBlockSegmentTreeProbs[n3] = n2;
                    }
                }
            }
        }
        this.simpleFilter = bitDecoder.getBit();
        this.filterLevel = bitDecoder.getLiteral(6);
        this.sharpnessLevel = bitDecoder.getLiteral(3);
        this.modeRefLoopFilterDeltaEnabled = bitDecoder.getBit();
        if (this.modeRefLoopFilterDeltaEnabled > 0) {
            this.modeRefLoopFilterDeltaUpdate = bitDecoder.getBit();
            if (this.modeRefLoopFilterDeltaUpdate > 0) {
                for (n3 = 0; n3 < 4; ++n3) {
                    if (bitDecoder.getBit() <= 0) continue;
                    this.refLoopFilterDeltas[n3] = bitDecoder.getLiteral(6);
                    if (bitDecoder.getBit() <= 0) continue;
                    int n11 = n3;
                    this.refLoopFilterDeltas[n11] = this.refLoopFilterDeltas[n11] * -1;
                }
                for (n3 = 0; n3 < 4; ++n3) {
                    if (bitDecoder.getBit() <= 0) continue;
                    this.modeLoopFilterDeltas[n3] = bitDecoder.getLiteral(6);
                    if (bitDecoder.getBit() <= 0) continue;
                    int n12 = n3;
                    this.modeLoopFilterDeltas[n12] = this.modeLoopFilterDeltas[n12] * -1;
                }
            }
        }
        this.filterType = this.filterLevel == 0 ? 0 : (this.simpleFilter > 0 ? 1 : 2);
        this.setupTokenDecoder(bitDecoder, n6, this.offset);
        bitDecoder.seek();
        this.segmentQuants.parse(bitDecoder, this.segmentationIsEnabled == 1, this.macroBlockSegementAbsoluteDelta == 1);
        if (this.frameType != 0) {
            throw new IllegalArgumentException("bad input: not intra");
        }
        this.refreshEntropyProbs = bitDecoder.getBit();
        if (this.refreshEntropyProbs > 0) {
            // empty if block
        }
        if (this.frameType != 0) {
            bitDecoder.getBit();
        }
        for (n3 = 0; n3 < 4; ++n3) {
            for (n2 = 0; n2 < 8; ++n2) {
                for (n = 0; n < 3; ++n) {
                    for (int i = 0; i < 11; ++i) {
                        int n13;
                        if (bitDecoder.getProbBit(LookUp.PROB_COS[n3][n2][n][i]) <= 0) continue;
                        this.coefProbs[n3][n2][n][i] = n13 = bitDecoder.getLiteral(8);
                    }
                }
            }
        }
        this.macroBlockNoCoeffSkip = bitDecoder.getBit();
        if (this.frameType != 0) {
            throw new IllegalArgumentException("bad input: not intra");
        }
        this.readModes(bitDecoder);
        n3 = 0;
        n2 = 1 << this.multiTokenPartition;
        for (n = 0; n < this.mbRows; ++n) {
            if (n2 > 1) {
                this.tokenBoolDecoder = this.tokenBitDecoders.get(n3);
                this.tokenBoolDecoder.seek();
                this.decodeMacroBlockRow(n);
                if (++n3 != n2) continue;
                n3 = 0;
                continue;
            }
            this.decodeMacroBlockRow(n);
        }
        if (this.filterType > 0 && this.filterLevel != 0) {
            Frame.filterFrame(this);
        }
        return true;
    }

    private void decodeMacroBlockRow(int n) throws IOException {
        for (int i = 0; i < this.mbCols; ++i) {
            MacroBlock macroBlock = this.getMacroBlock(i, n);
            macroBlock.decodeMacroBlock(this);
            macroBlock.dequantMacroBlock(this);
        }
    }

    public SubBlock getTopRightSubBlock(SubBlock subBlock, SubBlock.Layer layer) {
        MacroBlock macroBlock = subBlock.macroBlock;
        int n = macroBlock.getSubblockX(subBlock);
        int n2 = macroBlock.getSubblockY(subBlock);
        if (layer == SubBlock.Layer.Y1) {
            if (n2 == 0 && n < 3) {
                MacroBlock macroBlock2 = this.getMacroBlock(macroBlock.getX(), macroBlock.getY() - 1);
                SubBlock subBlock2 = macroBlock2.getSubBlock(layer, n + 1, 3);
                return subBlock2;
            }
            if (n2 == 0 && n == 3) {
                MacroBlock macroBlock3 = this.getMacroBlock(macroBlock.getX() + 1, macroBlock.getY() - 1);
                SubBlock subBlock3 = macroBlock3.getSubBlock(layer, 0, 3);
                if (macroBlock3.getX() == this.mbCols) {
                    int[][] nArray = new int[4][4];
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            nArray[j][i] = macroBlock3.getY() < 0 ? 127 : this.getMacroBlock(macroBlock.getX(), macroBlock.getY() - 1).getSubBlock(SubBlock.Layer.Y1, 3, 3).getDest()[3][3];
                        }
                    }
                    subBlock3 = new SubBlock(macroBlock3, null, null, SubBlock.Layer.Y1);
                    subBlock3.dest = nArray;
                }
                return subBlock3;
            }
            if (n2 > 0 && n < 3) {
                SubBlock subBlock4 = macroBlock.getSubBlock(layer, n + 1, n2 - 1);
                return subBlock4;
            }
            SubBlock subBlock5 = macroBlock.getSubBlock(subBlock.getLayer(), 3, 0);
            return this.getTopRightSubBlock(subBlock5, layer);
        }
        throw new IllegalArgumentException("bad input: getAboveRightSubBlock()");
    }

    public SubBlock getTopSubBlock(SubBlock subBlock, SubBlock.Layer layer) {
        SubBlock subBlock2 = subBlock.getAbove();
        if (subBlock2 == null) {
            MacroBlock macroBlock = subBlock.macroBlock;
            int n = macroBlock.getSubblockX(subBlock);
            MacroBlock macroBlock2 = this.getMacroBlock(macroBlock.getX(), macroBlock.getY() - 1);
            while (layer == SubBlock.Layer.Y2 && macroBlock2.getYMode() == 4) {
                macroBlock2 = this.getMacroBlock(macroBlock2.getX(), macroBlock2.getY() - 1);
            }
            subBlock2 = macroBlock2.getBottomSubBlock(n, subBlock.getLayer());
        }
        return subBlock2;
    }

    private boolean getBit(int n, int n2) {
        int n3 = n & 1 << n2;
        return n3 > 0;
    }

    private int getBitAsInt(int n, int n2) {
        int n3 = n & 1 << n2;
        if (n3 > 0) {
            return 1;
        }
        return 0;
    }

    public BufferedImage getBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int n2 = this.getMacroBlock(j / 16, i / 16).getSubBlock(SubBlock.Layer.Y1, j % 16 / 4, i % 16 / 4).getDest()[j % 4][i % 4];
                int n3 = this.getMacroBlock(j / 16, i / 16).getSubBlock(SubBlock.Layer.U, j / 2 % 8 / 4, i / 2 % 8 / 4).getDest()[j / 2 % 4][i / 2 % 4];
                int n4 = this.getMacroBlock(j / 16, i / 16).getSubBlock(SubBlock.Layer.V, j / 2 % 8 / 4, i / 2 % 8 / 4).getDest()[j / 2 % 4][i / 2 % 4];
                int n5 = 1192 * (n2 - 16);
                int n6 = 1634 * (n4 -= 128);
                int n7 = 832 * n4;
                int n8 = 400 * (n3 -= 128);
                int n9 = 2066 * n3;
                int n10 = n5 + n6 >> 10;
                int n11 = n5 - n7 - n8 >> 10;
                int n12 = n5 + n9 >> 10;
                int n13 = n10 > 255 ? 255 : (n10 = n10 < 0 ? 0 : n10);
                int n14 = n11 > 255 ? 255 : (n11 = n11 < 0 ? 0 : n11);
                n12 = n12 > 255 ? 255 : (n12 < 0 ? 0 : n12);
                nArray[n++] = n10 << 16 | n11 << 8 | n12;
            }
        }
        return bufferedImage;
    }

    public int[][][][] getCoefProbs() {
        return this.coefProbs;
    }

    public SubBlock getLeftSubBlock(SubBlock subBlock, SubBlock.Layer layer) {
        SubBlock subBlock2 = subBlock.getLeft();
        if (subBlock2 == null) {
            MacroBlock macroBlock = subBlock.macroBlock;
            int n = macroBlock.getSubblockY(subBlock);
            MacroBlock macroBlock2 = this.getMacroBlock(macroBlock.getX() - 1, macroBlock.getY());
            while (layer == SubBlock.Layer.Y2 && macroBlock2.getYMode() == 4) {
                macroBlock2 = this.getMacroBlock(macroBlock2.getX() - 1, macroBlock2.getY());
            }
            subBlock2 = macroBlock2.getRightSubBlock(n, subBlock.getLayer());
        }
        return subBlock2;
    }

    public MacroBlock getMacroBlock(int n, int n2) {
        return this.macroBlocks[n + 1][n2 + 1];
    }

    public int getMacroBlockCols() {
        return this.mbCols;
    }

    public int getMacroBlockRows() {
        return this.mbRows;
    }

    public int getQIndex() {
        return this.segmentQuants.index;
    }

    public SegmentQuants getSegmentQuants() {
        return this.segmentQuants;
    }

    public BitDecoder getTokenBoolDecoder() throws IOException {
        this.tokenBoolDecoder.seek();
        return this.tokenBoolDecoder;
    }

    public int[][] getUBuffer() {
        int[][] nArray = new int[this.mbCols * 8][this.mbRows * 8];
        for (int i = 0; i < this.mbRows; ++i) {
            for (int j = 0; j < this.mbCols; ++j) {
                MacroBlock macroBlock = this.macroBlocks[j + 1][i + 1];
                for (int k = 0; k < 2; ++k) {
                    for (int i2 = 0; i2 < 2; ++i2) {
                        SubBlock subBlock = macroBlock.getUSubBlock(i2, k);
                        for (int i3 = 0; i3 < 4; ++i3) {
                            for (int i4 = 0; i4 < 4; ++i4) {
                                nArray[j * 8 + i2 * 4 + i4][i * 8 + k * 4 + i3] = subBlock.getDest()[i4][i3];
                            }
                        }
                    }
                }
            }
        }
        return nArray;
    }

    public int[][] getVBuffer() {
        int[][] nArray = new int[this.mbCols * 8][this.mbRows * 8];
        for (int i = 0; i < this.mbRows; ++i) {
            for (int j = 0; j < this.mbCols; ++j) {
                MacroBlock macroBlock = this.macroBlocks[j + 1][i + 1];
                for (int k = 0; k < 2; ++k) {
                    for (int i2 = 0; i2 < 2; ++i2) {
                        SubBlock subBlock = macroBlock.getVSubBlock(i2, k);
                        for (int i3 = 0; i3 < 4; ++i3) {
                            for (int i4 = 0; i4 < 4; ++i4) {
                                nArray[(j << 3) + (i2 << 2) + i4][(i << 3) + (k << 2) + i3] = subBlock.getDest()[i4][i3];
                            }
                        }
                    }
                }
            }
        }
        return nArray;
    }

    public int[][] getYBuffer() {
        int[][] nArray = new int[this.mbCols * 16][this.mbRows * 16];
        for (int i = 0; i < this.mbRows; ++i) {
            for (int j = 0; j < this.mbCols; ++j) {
                MacroBlock macroBlock = this.macroBlocks[j + 1][i + 1];
                for (int k = 0; k < 4; ++k) {
                    for (int i2 = 0; i2 < 4; ++i2) {
                        SubBlock subBlock = macroBlock.getYSubBlock(i2, k);
                        for (int i3 = 0; i3 < 4; ++i3) {
                            for (int i4 = 0; i4 < 4; ++i4) {
                                nArray[j * 16 + i2 * 4 + i4][i * 16 + k * 4 + i3] = subBlock.getDest()[i4][i3];
                            }
                        }
                    }
                }
            }
        }
        return nArray;
    }

    private void readModes(BitDecoder bitDecoder) throws IOException {
        int n = -1;
        int n2 = 0;
        if (this.macroBlockNoCoeffSkip > 0) {
            n2 = bitDecoder.getLiteral(8);
        }
        while (++n < this.mbRows) {
            int n3 = -1;
            while (++n3 < this.mbCols) {
                SubBlock subBlock;
                int n4;
                int n5;
                int n6;
                MacroBlock macroBlock = this.getMacroBlock(n3, n);
                if (this.segmentationIsEnabled > 0 && this.mBlockMap > 0) {
                    macroBlock.key = bitDecoder.getTree(LookUp.MB_SEG_TREE, this.macroBlockSegmentTreeProbs);
                }
                if (this.modeRefLoopFilterDeltaEnabled > 0) {
                    n6 = this.filterLevel;
                    n6 = (n6 += this.refLoopFilterDeltas[0]) < 0 ? 0 : (n6 > 63 ? 63 : n6);
                    macroBlock.setFilterLevel(n6);
                } else {
                    macroBlock.setFilterLevel(this.segmentQuants.segQuants[macroBlock.key].strength);
                }
                n6 = this.macroBlockNoCoeffSkip > 0 ? bitDecoder.getProbBit(n2) : 0;
                macroBlock.setSkipCoeff(n6);
                int n7 = this.readYMode(bitDecoder);
                macroBlock.setYMode(n7);
                if (n7 == 4) {
                    for (n5 = 0; n5 < 4; ++n5) {
                        for (n4 = 0; n4 < 4; ++n4) {
                            SubBlock subBlock2 = macroBlock.getYSubBlock(n4, n5);
                            subBlock = this.getTopSubBlock(subBlock2, SubBlock.Layer.Y1);
                            SubBlock subBlock3 = this.getLeftSubBlock(subBlock2, SubBlock.Layer.Y1);
                            int n8 = this.readSubBlockMode(bitDecoder, subBlock.mode, subBlock3.mode);
                            subBlock2.setMode(n8);
                        }
                    }
                    if (this.modeRefLoopFilterDeltaEnabled > 0) {
                        n5 = macroBlock.getFilterLevel();
                        n5 = (n5 += this.modeLoopFilterDeltas[0]) < 0 ? 0 : (n5 > 63 ? 63 : n5);
                        macroBlock.setFilterLevel(n5);
                    }
                } else {
                    switch (n7) {
                        case 0: {
                            n5 = 0;
                            break;
                        }
                        case 1: {
                            n5 = 2;
                            break;
                        }
                        case 2: {
                            n5 = 3;
                            break;
                        }
                        case 3: {
                            n5 = 1;
                            break;
                        }
                        default: {
                            n5 = 0;
                        }
                    }
                    for (n4 = 0; n4 < 4; ++n4) {
                        for (int i = 0; i < 4; ++i) {
                            subBlock = macroBlock.getYSubBlock(n4, i);
                            subBlock.setMode(n5);
                        }
                    }
                }
                n5 = this.readUvMode(bitDecoder);
                macroBlock.setUvMode(n5);
            }
        }
    }

    private int readPartitionSize(int n) {
        this.reader.seek(n);
        int n2 = this.reader.getUINT8() + (this.reader.getUINT8() << 8) + (this.reader.getUINT8() << 16);
        return n2;
    }

    private int readSubBlockMode(BitDecoder bitDecoder, int n, int n2) throws IOException {
        int n3 = bitDecoder.getTree(LookUp.SUBBLOCK_MODE_TREE, LookUp.FRAMES_SUBBLOCK[n][n2]);
        return n3;
    }

    private int readUvMode(BitDecoder bitDecoder) throws IOException {
        int n = bitDecoder.getTree(LookUp.UV_MODE_TREE, LookUp.UV_FRAME_PROB);
        return n;
    }

    private int readYMode(BitDecoder bitDecoder) throws IOException {
        int n = bitDecoder.getTree(LookUp.Y_FRAME_TREE, LookUp.FRAME_YMODE_PROB);
        return n;
    }

    private void setupTokenDecoder(BitDecoder bitDecoder, int n, int n2) throws IOException {
        int n3;
        int n4 = n3 = n2 + n;
        this.multiTokenPartition = bitDecoder.getLiteral(2);
        int n5 = 1 << this.multiTokenPartition;
        if (n5 > 1) {
            n4 += 3 * (n5 - 1);
        }
        for (int i = 0; i < n5; ++i) {
            int n6;
            if (i < n5 - 1) {
                n6 = this.readPartitionSize(n3 + i * 3);
                bitDecoder.seek();
            } else {
                n6 = this.reader.getSize() - n4;
            }
            this.tokenBitDecoders.add(new BitDecoder(this.reader, n4));
            n4 += n6;
        }
        this.tokenBoolDecoder = this.tokenBitDecoders.get(0);
    }

    private static int common_adjust(boolean bl, Segment segment) {
        int n = Frame.getSigned(segment.P1);
        int n2 = Frame.getSigned(segment.P0);
        int n3 = Frame.getSigned(segment.Q0);
        int n4 = Frame.getSigned(segment.Q1);
        int n5 = Frame.sClamp((bl ? Frame.sClamp(n - n4) : 0) + 3 * (n3 - n2));
        int n6 = Frame.sClamp(n5 + 3) >> 3;
        n5 = Frame.sClamp(n5 + 4) >> 3;
        segment.Q0 = Frame.getUnsigned(n3 - n5);
        segment.P0 = Frame.getUnsigned(n2 + n6);
        return n5;
    }

    private static boolean doY(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return Frame.abs(n6 - n7) * 2 + Frame.abs(n5 - n8) / 2 <= n2 && Frame.abs(n3 - n4) <= n && Frame.abs(n4 - n5) <= n && Frame.abs(n5 - n6) <= n && Frame.abs(n10 - n9) <= n && Frame.abs(n9 - n8) <= n && Frame.abs(n8 - n7) <= n;
    }

    private static Segment getSegH(SubBlock subBlock, SubBlock subBlock2, int n) {
        Segment segment = new Segment();
        int[][] nArray = subBlock.getDest();
        int[][] nArray2 = subBlock2.getDest();
        segment.P0 = nArray2[3][n];
        segment.P1 = nArray2[2][n];
        segment.P2 = nArray2[1][n];
        segment.P3 = nArray2[0][n];
        segment.Q0 = nArray[0][n];
        segment.Q1 = nArray[1][n];
        segment.Q2 = nArray[2][n];
        segment.Q3 = nArray[3][n];
        return segment;
    }

    private static Segment getSegV(SubBlock subBlock, SubBlock subBlock2, int n) {
        Segment segment = new Segment();
        int[][] nArray = subBlock.getDest();
        int[][] nArray2 = subBlock2.getDest();
        segment.P0 = nArray2[n][3];
        segment.P1 = nArray2[n][2];
        segment.P2 = nArray2[n][1];
        segment.P3 = nArray2[n][0];
        segment.Q0 = nArray[n][0];
        segment.Q1 = nArray[n][1];
        segment.Q2 = nArray[n][2];
        segment.Q3 = nArray[n][3];
        return segment;
    }

    private static boolean hev(int n, int n2, int n3, int n4, int n5) {
        return Frame.abs(n2 - n3) > n || Frame.abs(n5 - n4) > n;
    }

    private static void filterFrame(Frame frame) {
        if (frame.filterType == 2) {
            Frame.filterUV(frame);
            Frame.filterY(frame);
        } else if (frame.filterType == 1) {
            Frame.filterNorm(frame);
        }
    }

    private static void filterNorm(Frame frame) {
        for (int i = 0; i < frame.mbRows; ++i) {
            for (int j = 0; j < frame.mbCols; ++j) {
                Segment segment;
                int n;
                SubBlock subBlock;
                SubBlock subBlock2;
                int n2;
                MacroBlock macroBlock;
                int n3;
                MacroBlock macroBlock2 = frame.getMacroBlock(j, i);
                MacroBlock macroBlock3 = frame.getMacroBlock(j, i);
                int n4 = macroBlock2.getFilterLevel();
                if (n4 == 0) continue;
                int n5 = macroBlock2.getFilterLevel();
                int n6 = frame.sharpnessLevel;
                if (n6 > 0 && (n5 >>= n6 > 4 ? 2 : 1) > 9 - n6) {
                    n5 = 9 - n6;
                }
                if (n5 == 0) {
                    n5 = 1;
                }
                if ((n3 = (n4 << 1) + n5) < 1) {
                    n3 = 1;
                }
                int n7 = n3 + 4;
                if (j > 0) {
                    macroBlock = frame.getMacroBlock(j - 1, i);
                    for (n2 = 0; n2 < 4; ++n2) {
                        subBlock2 = macroBlock2.getSubBlock(SubBlock.Layer.Y1, 0, n2);
                        subBlock = macroBlock.getSubBlock(SubBlock.Layer.Y1, 3, n2);
                        for (n = 0; n < 4; ++n) {
                            segment = Frame.getSegH(subBlock2, subBlock, n);
                            Frame.normalizeSegment(n7, segment);
                            Frame.setSegH(subBlock2, subBlock, segment, n);
                        }
                    }
                }
                if (!macroBlock2.isSkip_inner_lf()) {
                    for (int k = 1; k < 4; ++k) {
                        for (n2 = 0; n2 < 4; ++n2) {
                            subBlock2 = macroBlock2.getSubBlock(SubBlock.Layer.Y1, k - 1, n2);
                            subBlock = macroBlock2.getSubBlock(SubBlock.Layer.Y1, k, n2);
                            for (n = 0; n < 4; ++n) {
                                segment = Frame.getSegH(subBlock, subBlock2, n);
                                Frame.normalizeSegment(n3, segment);
                                Frame.setSegH(subBlock, subBlock2, segment, n);
                            }
                        }
                    }
                }
                if (i > 0) {
                    macroBlock = frame.getMacroBlock(j, i - 1);
                    for (n2 = 0; n2 < 4; ++n2) {
                        subBlock2 = macroBlock.getSubBlock(SubBlock.Layer.Y1, n2, 3);
                        subBlock = macroBlock3.getSubBlock(SubBlock.Layer.Y1, n2, 0);
                        for (n = 0; n < 4; ++n) {
                            segment = Frame.getSegV(subBlock, subBlock2, n);
                            Frame.normalizeSegment(n7, segment);
                            Frame.setSegV(subBlock, subBlock2, segment, n);
                        }
                    }
                }
                if (macroBlock2.isSkip_inner_lf()) continue;
                for (int k = 1; k < 4; ++k) {
                    for (n2 = 0; n2 < 4; ++n2) {
                        subBlock2 = macroBlock3.getSubBlock(SubBlock.Layer.Y1, n2, k - 1);
                        subBlock = macroBlock3.getSubBlock(SubBlock.Layer.Y1, n2, k);
                        for (n = 0; n < 4; ++n) {
                            segment = Frame.getSegV(subBlock, subBlock2, n);
                            Frame.normalizeSegment(n3, segment);
                            Frame.setSegV(subBlock, subBlock2, segment, n);
                        }
                    }
                }
            }
        }
    }

    private static void filterUV(Frame frame) {
        for (int i = 0; i < frame.mbRows; ++i) {
            for (int j = 0; j < frame.mbCols; ++j) {
                Segment segment;
                int n;
                SubBlock subBlock;
                SubBlock subBlock2;
                SubBlock subBlock3;
                SubBlock subBlock4;
                int n2;
                MacroBlock macroBlock;
                MacroBlock macroBlock2 = frame.getMacroBlock(j, i);
                MacroBlock macroBlock3 = frame.getMacroBlock(j, i);
                int n3 = frame.sharpnessLevel;
                int n4 = macroBlock2.getFilterLevel();
                if (n4 == 0) continue;
                int n5 = macroBlock2.getFilterLevel();
                if (n3 > 0 && (n5 >>= n3 > 4 ? 2 : 1) > 9 - n3) {
                    n5 = 9 - n3;
                }
                if (n5 == 0) {
                    n5 = 1;
                }
                int n6 = 0;
                if (frame.frameType == 0) {
                    if (n4 >= 40) {
                        n6 = 2;
                    } else if (n4 >= 15) {
                        n6 = 1;
                    }
                } else if (n4 >= 40) {
                    n6 = 3;
                } else if (n4 >= 20) {
                    n6 = 2;
                } else if (n4 >= 15) {
                    n6 = 1;
                }
                int n7 = (n4 + 2 << 1) + n5;
                int n8 = (n4 << 1) + n5;
                if (j > 0) {
                    macroBlock = frame.getMacroBlock(j - 1, i);
                    for (n2 = 0; n2 < 2; ++n2) {
                        subBlock4 = macroBlock2.getSubBlock(SubBlock.Layer.U, 0, n2);
                        subBlock3 = macroBlock.getSubBlock(SubBlock.Layer.U, 1, n2);
                        subBlock2 = macroBlock2.getSubBlock(SubBlock.Layer.V, 0, n2);
                        subBlock = macroBlock.getSubBlock(SubBlock.Layer.V, 1, n2);
                        for (n = 0; n < 4; ++n) {
                            segment = Frame.getSegH(subBlock4, subBlock3, n);
                            Frame.filterMB(n6, n5, n7, segment);
                            Frame.setSegH(subBlock4, subBlock3, segment, n);
                            segment = Frame.getSegH(subBlock2, subBlock, n);
                            Frame.filterMB(n6, n5, n7, segment);
                            Frame.setSegH(subBlock2, subBlock, segment, n);
                        }
                    }
                }
                if (!macroBlock2.isSkip_inner_lf()) {
                    for (int k = 1; k < 2; ++k) {
                        for (n2 = 0; n2 < 2; ++n2) {
                            subBlock4 = macroBlock2.getSubBlock(SubBlock.Layer.U, k - 1, n2);
                            subBlock3 = macroBlock2.getSubBlock(SubBlock.Layer.U, k, n2);
                            subBlock2 = macroBlock2.getSubBlock(SubBlock.Layer.V, k - 1, n2);
                            subBlock = macroBlock2.getSubBlock(SubBlock.Layer.V, k, n2);
                            for (n = 0; n < 4; ++n) {
                                segment = Frame.getSegH(subBlock3, subBlock4, n);
                                Frame.filterSB(n6, n5, n8, segment);
                                Frame.setSegH(subBlock3, subBlock4, segment, n);
                                segment = Frame.getSegH(subBlock, subBlock2, n);
                                Frame.filterSB(n6, n5, n8, segment);
                                Frame.setSegH(subBlock, subBlock2, segment, n);
                            }
                        }
                    }
                }
                if (i > 0) {
                    macroBlock = frame.getMacroBlock(j, i - 1);
                    for (n2 = 0; n2 < 2; ++n2) {
                        subBlock4 = macroBlock.getSubBlock(SubBlock.Layer.U, n2, 1);
                        subBlock3 = macroBlock3.getSubBlock(SubBlock.Layer.U, n2, 0);
                        subBlock2 = macroBlock.getSubBlock(SubBlock.Layer.V, n2, 1);
                        subBlock = macroBlock3.getSubBlock(SubBlock.Layer.V, n2, 0);
                        for (n = 0; n < 4; ++n) {
                            segment = Frame.getSegV(subBlock3, subBlock4, n);
                            Frame.filterMB(n6, n5, n7, segment);
                            Frame.setSegV(subBlock3, subBlock4, segment, n);
                            segment = Frame.getSegV(subBlock, subBlock2, n);
                            Frame.filterMB(n6, n5, n7, segment);
                            Frame.setSegV(subBlock, subBlock2, segment, n);
                        }
                    }
                }
                if (macroBlock2.isSkip_inner_lf()) continue;
                for (int k = 1; k < 2; ++k) {
                    for (n2 = 0; n2 < 2; ++n2) {
                        subBlock4 = macroBlock3.getSubBlock(SubBlock.Layer.U, n2, k - 1);
                        subBlock3 = macroBlock3.getSubBlock(SubBlock.Layer.U, n2, k);
                        subBlock2 = macroBlock3.getSubBlock(SubBlock.Layer.V, n2, k - 1);
                        subBlock = macroBlock3.getSubBlock(SubBlock.Layer.V, n2, k);
                        for (n = 0; n < 4; ++n) {
                            segment = Frame.getSegV(subBlock3, subBlock4, n);
                            Frame.filterSB(n6, n5, n8, segment);
                            Frame.setSegV(subBlock3, subBlock4, segment, n);
                            segment = Frame.getSegV(subBlock, subBlock2, n);
                            Frame.filterSB(n6, n5, n8, segment);
                            Frame.setSegV(subBlock, subBlock2, segment, n);
                        }
                    }
                }
            }
        }
    }

    private static void filterY(Frame frame) {
        for (int i = 0; i < frame.mbRows; ++i) {
            for (int j = 0; j < frame.mbCols; ++j) {
                Segment segment;
                int n;
                SubBlock subBlock;
                SubBlock subBlock2;
                int n2;
                MacroBlock macroBlock;
                MacroBlock macroBlock2 = frame.getMacroBlock(j, i);
                MacroBlock macroBlock3 = frame.getMacroBlock(j, i);
                int n3 = frame.sharpnessLevel;
                int n4 = macroBlock2.getFilterLevel();
                if (n4 == 0) continue;
                int n5 = macroBlock2.getFilterLevel();
                if (n3 > 0 && (n5 >>= n3 > 4 ? 2 : 1) > 9 - n3) {
                    n5 = 9 - n3;
                }
                if (n5 == 0) {
                    n5 = 1;
                }
                int n6 = 0;
                if (frame.frameType == 0) {
                    if (n4 >= 40) {
                        n6 = 2;
                    } else if (n4 >= 15) {
                        n6 = 1;
                    }
                } else if (n4 >= 40) {
                    n6 = 3;
                } else if (n4 >= 20) {
                    n6 = 2;
                } else if (n4 >= 15) {
                    n6 = 1;
                }
                int n7 = (n4 + 2 << 1) + n5;
                int n8 = (n4 << 1) + n5;
                if (j > 0) {
                    macroBlock = frame.getMacroBlock(j - 1, i);
                    for (n2 = 0; n2 < 4; ++n2) {
                        subBlock2 = macroBlock2.getSubBlock(SubBlock.Layer.Y1, 0, n2);
                        subBlock = macroBlock.getSubBlock(SubBlock.Layer.Y1, 3, n2);
                        for (n = 0; n < 4; ++n) {
                            segment = Frame.getSegH(subBlock2, subBlock, n);
                            Frame.filterMB(n6, n5, n7, segment);
                            Frame.setSegH(subBlock2, subBlock, segment, n);
                        }
                    }
                }
                if (!macroBlock2.isSkip_inner_lf()) {
                    for (int k = 1; k < 4; ++k) {
                        for (n2 = 0; n2 < 4; ++n2) {
                            subBlock2 = macroBlock2.getSubBlock(SubBlock.Layer.Y1, k - 1, n2);
                            subBlock = macroBlock2.getSubBlock(SubBlock.Layer.Y1, k, n2);
                            for (n = 0; n < 4; ++n) {
                                segment = Frame.getSegH(subBlock, subBlock2, n);
                                Frame.filterSB(n6, n5, n8, segment);
                                Frame.setSegH(subBlock, subBlock2, segment, n);
                            }
                        }
                    }
                }
                if (i > 0) {
                    macroBlock = frame.getMacroBlock(j, i - 1);
                    for (n2 = 0; n2 < 4; ++n2) {
                        subBlock2 = macroBlock.getSubBlock(SubBlock.Layer.Y1, n2, 3);
                        subBlock = macroBlock3.getSubBlock(SubBlock.Layer.Y1, n2, 0);
                        for (n = 0; n < 4; ++n) {
                            segment = Frame.getSegV(subBlock, subBlock2, n);
                            Frame.filterMB(n6, n5, n7, segment);
                            Frame.setSegV(subBlock, subBlock2, segment, n);
                        }
                    }
                }
                if (macroBlock2.isSkip_inner_lf()) continue;
                for (int k = 1; k < 4; ++k) {
                    for (n2 = 0; n2 < 4; ++n2) {
                        subBlock2 = macroBlock3.getSubBlock(SubBlock.Layer.Y1, n2, k - 1);
                        subBlock = macroBlock3.getSubBlock(SubBlock.Layer.Y1, n2, k);
                        for (n = 0; n < 4; ++n) {
                            segment = Frame.getSegV(subBlock, subBlock2, n);
                            Frame.filterSB(n6, n5, n8, segment);
                            Frame.setSegV(subBlock, subBlock2, segment, n);
                        }
                    }
                }
            }
        }
    }

    private static void filterMB(int n, int n2, int n3, Segment segment) {
        int n4 = Frame.getSigned(segment.P3);
        int n5 = Frame.getSigned(segment.P2);
        int n6 = Frame.getSigned(segment.P1);
        int n7 = Frame.getSigned(segment.P0);
        int n8 = Frame.getSigned(segment.Q0);
        int n9 = Frame.getSigned(segment.Q1);
        int n10 = Frame.getSigned(segment.Q2);
        int n11 = Frame.getSigned(segment.Q3);
        if (Frame.doY(n2, n3, n11, n10, n9, n8, n7, n6, n5, n4)) {
            if (!Frame.hev(n, n6, n7, n8, n9)) {
                int n12 = Frame.sClamp(Frame.sClamp(n6 - n9) + 3 * (n8 - n7));
                int n13 = 27 * n12 + 63 >> 7;
                segment.Q0 = Frame.getUnsigned(n8 - n13);
                segment.P0 = Frame.getUnsigned(n7 + n13);
                n13 = 18 * n12 + 63 >> 7;
                segment.Q1 = Frame.getUnsigned(n9 - n13);
                segment.P1 = Frame.getUnsigned(n6 + n13);
                n13 = 9 * n12 + 63 >> 7;
                segment.Q2 = Frame.getUnsigned(n10 - n13);
                segment.P2 = Frame.getUnsigned(n5 + n13);
            } else {
                Frame.common_adjust(true, segment);
            }
        }
    }

    private static void setSegH(SubBlock subBlock, SubBlock subBlock2, Segment segment, int n) {
        int[][] nArray = subBlock.getDest();
        int[][] nArray2 = subBlock2.getDest();
        nArray2[3][n] = segment.P0;
        nArray2[2][n] = segment.P1;
        nArray2[1][n] = segment.P2;
        nArray2[0][n] = segment.P3;
        nArray[0][n] = segment.Q0;
        nArray[1][n] = segment.Q1;
        nArray[2][n] = segment.Q2;
        nArray[3][n] = segment.Q3;
    }

    private static void setSegV(SubBlock subBlock, SubBlock subBlock2, Segment segment, int n) {
        int[][] nArray = subBlock.getDest();
        int[][] nArray2 = subBlock2.getDest();
        nArray2[n][3] = segment.P0;
        nArray2[n][2] = segment.P1;
        nArray2[n][1] = segment.P2;
        nArray2[n][0] = segment.P3;
        nArray[n][0] = segment.Q0;
        nArray[n][1] = segment.Q1;
        nArray[n][2] = segment.Q2;
        nArray[n][3] = segment.Q3;
    }

    private static void normalizeSegment(int n, Segment segment) {
        if (Frame.abs(segment.P0 - segment.Q0) * 2 + Frame.abs(segment.P1 - segment.Q1) / 2 <= n) {
            Frame.common_adjust(true, segment);
        }
    }

    private static void filterSB(int n, int n2, int n3, Segment segment) {
        int n4 = Frame.getSigned(segment.P3);
        int n5 = Frame.getSigned(segment.P2);
        int n6 = Frame.getSigned(segment.P1);
        int n7 = Frame.getSigned(segment.P0);
        int n8 = Frame.getSigned(segment.Q0);
        int n9 = Frame.getSigned(segment.Q1);
        int n10 = Frame.getSigned(segment.Q2);
        int n11 = Frame.getSigned(segment.Q3);
        if (Frame.doY(n2, n3, n11, n10, n9, n8, n7, n6, n5, n4)) {
            boolean bl = Frame.hev(n, n6, n7, n8, n9);
            int n12 = Frame.common_adjust(bl, segment) + 1 >> 1;
            if (!bl) {
                segment.Q1 = Frame.getUnsigned(n9 - n12);
                segment.P1 = Frame.getUnsigned(n6 + n12);
            }
        }
    }

    private static int getSigned(int n) {
        return n - 128;
    }

    private static int getUnsigned(int n) {
        return Frame.sClamp(n) + 128;
    }

    private static int abs(int n) {
        return n < 0 ? -n : n;
    }

    private static int sClamp(int n) {
        int n2 = n;
        if (n < -128) {
            n2 = -128;
        }
        if (n > 127) {
            n2 = 127;
        }
        return n2;
    }

    private static class Segment {
        int P0;
        int P1;
        int P2;
        int P3;
        int Q0;
        int Q1;
        int Q2;
        int Q3;

        private Segment() {
        }
    }
}

