/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webm;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LittleReader {
    private final ByteBuffer buffer;
    private final int length;

    public LittleReader(byte[] byArray) {
        this.buffer = ByteBuffer.wrap(byArray);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.length = byArray.length;
    }

    public int getUINT8() {
        return this.buffer.get() & 0xFF;
    }

    public int getUINT16() {
        return this.buffer.getShort() & 0xFFFF;
    }

    public int getUINT32() {
        return this.buffer.getInt();
    }

    public String getFOURCC() {
        byte[] byArray = new byte[4];
        this.buffer.get(byArray);
        return new String(byArray);
    }

    public void seek(int n) {
        this.buffer.position(n);
    }

    public int getPosition() {
        return this.buffer.position();
    }

    public int getSize() {
        return this.length;
    }
}

