/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webm;

import com.idrsolutions.image.webm.Frame;
import com.idrsolutions.image.webm.SubBlock;
import com.idrsolutions.image.webm.Transform;
import java.io.IOException;

public class MacroBlock {
    int filterLevel;
    private final boolean keepDebugInfo;
    int key;
    private int skipCoeff;
    private boolean innerLoopSkip;
    SubBlock[][] uSubBlocks;
    private int uVFilterLevel;
    private int uvMode;
    SubBlock[][] vSubBlocks;
    private final int x;
    private final int y;
    SubBlock y2SubBlock;
    private int yMode;
    SubBlock[][] ySubBlocks;

    MacroBlock(int n, int n2, boolean bl) {
        SubBlock subBlock;
        SubBlock subBlock2;
        int n3;
        int n4;
        this.x = n - 1;
        this.y = n2 - 1;
        this.keepDebugInfo = bl;
        this.ySubBlocks = new SubBlock[4][4];
        this.uSubBlocks = new SubBlock[2][2];
        this.vSubBlocks = new SubBlock[2][2];
        for (n4 = 0; n4 < 4; ++n4) {
            for (n3 = 0; n3 < 4; ++n3) {
                subBlock2 = null;
                subBlock = null;
                if (n3 > 0) {
                    subBlock2 = this.ySubBlocks[n3 - 1][n4];
                }
                if (n4 > 0) {
                    subBlock = this.ySubBlocks[n3][n4 - 1];
                }
                this.ySubBlocks[n3][n4] = new SubBlock(this, subBlock, subBlock2, SubBlock.Layer.Y1);
            }
        }
        for (n4 = 0; n4 < 2; ++n4) {
            for (n3 = 0; n3 < 2; ++n3) {
                subBlock2 = null;
                subBlock = null;
                if (n3 > 0) {
                    subBlock2 = this.uSubBlocks[n3 - 1][n4];
                }
                if (n4 > 0) {
                    subBlock = this.uSubBlocks[n3][n4 - 1];
                }
                this.uSubBlocks[n3][n4] = new SubBlock(this, subBlock, subBlock2, SubBlock.Layer.U);
            }
        }
        for (n4 = 0; n4 < 2; ++n4) {
            for (n3 = 0; n3 < 2; ++n3) {
                subBlock2 = null;
                subBlock = null;
                if (n3 > 0) {
                    subBlock2 = this.vSubBlocks[n3 - 1][n4];
                }
                if (n4 > 0) {
                    subBlock = this.vSubBlocks[n3][n4 - 1];
                }
                this.vSubBlocks[n3][n4] = new SubBlock(this, subBlock, subBlock2, SubBlock.Layer.V);
            }
        }
        this.y2SubBlock = new SubBlock(this, null, null, SubBlock.Layer.Y2);
    }

    public void decodeMacroBlock(Frame frame) throws IOException {
        if (this.skipCoeff > 0) {
            if (this.yMode != 4) {
                this.innerLoopSkip = true;
            }
        } else if (this.yMode != 4) {
            this.decodeMacroBlockTokens(frame, true);
        } else {
            this.decodeMacroBlockTokens(frame, false);
        }
    }

    private void decodeMacroBlockTokens(Frame frame, boolean bl) throws IOException {
        this.innerLoopSkip = false;
        if (bl) {
            this.innerLoopSkip |= this.decodePlaneTokens(frame, 1, SubBlock.Layer.Y2, false);
        }
        this.innerLoopSkip |= this.decodePlaneTokens(frame, 4, SubBlock.Layer.Y1, bl);
        this.innerLoopSkip |= this.decodePlaneTokens(frame, 2, SubBlock.Layer.U, false);
        this.innerLoopSkip |= this.decodePlaneTokens(frame, 2, SubBlock.Layer.V, false);
        this.innerLoopSkip = !this.innerLoopSkip;
    }

    private boolean decodePlaneTokens(Frame frame, int n, SubBlock.Layer layer, boolean bl) throws IOException {
        MacroBlock macroBlock = this;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                SubBlock subBlock = macroBlock.getSubBlock(layer, j, i);
                SubBlock subBlock2 = frame.getLeftSubBlock(subBlock, layer);
                SubBlock subBlock3 = frame.getTopSubBlock(subBlock, layer);
                if (subBlock2.hasNoZeroToken()) {
                    n2 = 1;
                }
                n4 += n2;
                if (subBlock3.hasNoZeroToken()) {
                    n3 = 1;
                }
                subBlock.decode(frame.getTokenBoolDecoder(), frame.getCoefProbs(), n4 += n3, SubBlock.layerToType(layer, bl), bl);
                bl2 |= subBlock.hasNoZeroToken();
            }
        }
        return bl2;
    }

    public void dequantMacroBlock(Frame frame) {
        MacroBlock macroBlock = this;
        if (macroBlock.yMode != 4) {
            SubBlock subBlock;
            int n;
            int n2;
            SubBlock subBlock2 = macroBlock.y2SubBlock;
            int n3 = frame.getSegmentQuants().segQuants[this.key].y2ac;
            int n4 = frame.getSegmentQuants().segQuants[this.key].y2dc;
            int[] nArray = new int[16];
            nArray[0] = subBlock2.getTokens()[0] * n4;
            for (n2 = 1; n2 < 16; ++n2) {
                nArray[n2] = subBlock2.getTokens()[n2] * n3;
            }
            subBlock2.diff = Transform.walsh(nArray);
            for (n2 = 0; n2 < 4; ++n2) {
                for (n = 0; n < 4; ++n) {
                    subBlock = macroBlock.getYSubBlock(n, n2);
                    subBlock.dequantSubBlock(frame, subBlock2.getDiff()[n][n2]);
                }
            }
            macroBlock.predictY(frame);
            macroBlock.predictUV(frame);
            for (n2 = 0; n2 < 2; ++n2) {
                for (n = 0; n < 2; ++n) {
                    subBlock = macroBlock.getUSubBlock(n, n2);
                    subBlock.dequantSubBlock(frame, null);
                    subBlock = macroBlock.getVSubBlock(n2, n);
                    subBlock.dequantSubBlock(frame, null);
                }
            }
            macroBlock.recon_mb();
        } else {
            SubBlock subBlock;
            int n;
            int n5;
            for (n5 = 0; n5 < 4; ++n5) {
                for (n = 0; n < 4; ++n) {
                    subBlock = macroBlock.getYSubBlock(n, n5);
                    subBlock.dequantSubBlock(frame, null);
                    subBlock.predict(frame);
                    subBlock.reconstruct();
                }
            }
            macroBlock.predictUV(frame);
            for (n5 = 0; n5 < 2; ++n5) {
                for (n = 0; n < 2; ++n) {
                    subBlock = macroBlock.getUSubBlock(n, n5);
                    subBlock.dequantSubBlock(frame, null);
                    subBlock.reconstruct();
                }
            }
            for (n5 = 0; n5 < 2; ++n5) {
                for (n = 0; n < 2; ++n) {
                    subBlock = macroBlock.getVSubBlock(n, n5);
                    subBlock.dequantSubBlock(frame, null);
                    subBlock.reconstruct();
                }
            }
        }
    }

    public SubBlock getBottomSubBlock(int n, SubBlock.Layer layer) {
        switch (layer) {
            case Y1: {
                return this.ySubBlocks[n][3];
            }
            case U: {
                return this.uSubBlocks[n][1];
            }
            case V: {
                return this.vSubBlocks[n][1];
            }
            case Y2: {
                return this.y2SubBlock;
            }
        }
        return null;
    }

    public int getFilterLevel() {
        return this.filterLevel;
    }

    public SubBlock getLeftSubBlock(int n, SubBlock.Layer layer) {
        if (layer == SubBlock.Layer.Y1) {
            return this.ySubBlocks[0][n];
        }
        if (layer == SubBlock.Layer.V) {
            return this.vSubBlocks[0][n];
        }
        if (layer == SubBlock.Layer.Y2) {
            return this.y2SubBlock;
        }
        if (layer == SubBlock.Layer.U) {
            return this.uSubBlocks[0][n];
        }
        return null;
    }

    public SubBlock getRightSubBlock(int n, SubBlock.Layer layer) {
        if (layer == SubBlock.Layer.Y1) {
            return this.ySubBlocks[3][n];
        }
        if (layer == SubBlock.Layer.U) {
            return this.uSubBlocks[1][n];
        }
        if (layer == SubBlock.Layer.V) {
            return this.vSubBlocks[1][n];
        }
        if (layer == SubBlock.Layer.Y2) {
            return this.y2SubBlock;
        }
        return null;
    }

    public SubBlock getSubBlock(SubBlock.Layer layer, int n, int n2) {
        switch (layer) {
            case Y1: {
                return this.getYSubBlock(n, n2);
            }
            case U: {
                return this.getUSubBlock(n, n2);
            }
            case V: {
                return this.getVSubBlock(n, n2);
            }
            case Y2: {
                return this.y2SubBlock;
            }
        }
        return null;
    }

    public int getSubblockX(SubBlock subBlock) {
        if (subBlock.getLayer() == SubBlock.Layer.Y1) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (this.ySubBlocks[j][i] != subBlock) continue;
                    return j;
                }
            }
        } else if (subBlock.getLayer() == SubBlock.Layer.U) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if (this.uSubBlocks[j][i] != subBlock) continue;
                    return j;
                }
            }
        } else if (subBlock.getLayer() == SubBlock.Layer.V) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if (this.vSubBlocks[j][i] != subBlock) continue;
                    return j;
                }
            }
        } else if (subBlock.getLayer() == SubBlock.Layer.Y2) {
            return 0;
        }
        return -100;
    }

    public int getSubblockY(SubBlock subBlock) {
        if (subBlock.getLayer() == SubBlock.Layer.Y1) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (this.ySubBlocks[j][i] != subBlock) continue;
                    return i;
                }
            }
        } else if (subBlock.getLayer() == SubBlock.Layer.U) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if (this.uSubBlocks[j][i] != subBlock) continue;
                    return i;
                }
            }
        } else if (subBlock.getLayer() == SubBlock.Layer.V) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if (this.vSubBlocks[j][i] != subBlock) continue;
                    return i;
                }
            }
        } else if (subBlock.getLayer() == SubBlock.Layer.Y2) {
            return 0;
        }
        return -100;
    }

    public SubBlock getUSubBlock(int n, int n2) {
        return this.uSubBlocks[n][n2];
    }

    public int getUVFilterLevel() {
        return this.uVFilterLevel;
    }

    public int getUvMode() {
        return this.uvMode;
    }

    public SubBlock getVSubBlock(int n, int n2) {
        return this.vSubBlocks[n][n2];
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getYMode() {
        return this.yMode;
    }

    public SubBlock getYSubBlock(int n, int n2) {
        return this.ySubBlocks[n][n2];
    }

    public boolean isKeepDebugInfo() {
        return this.keepDebugInfo;
    }

    public boolean isSkip_inner_lf() {
        return this.innerLoopSkip;
    }

    public void predictUV(Frame frame) {
        MacroBlock macroBlock = frame.getMacroBlock(this.x, this.y - 1);
        MacroBlock macroBlock2 = frame.getMacroBlock(this.x - 1, this.y);
        switch (this.uvMode) {
            case 0: {
                int n;
                int n2;
                int n3;
                int n4;
                boolean bl = false;
                boolean bl2 = false;
                int n5 = 0;
                int n6 = 0;
                if (this.x > 0) {
                    bl2 = true;
                }
                if (this.y > 0) {
                    bl = true;
                }
                if (bl || bl2) {
                    SubBlock subBlock;
                    SubBlock subBlock2;
                    int n7;
                    if (bl) {
                        for (n7 = 0; n7 < 2; ++n7) {
                            subBlock2 = macroBlock.getUSubBlock(n7, 1);
                            subBlock = macroBlock.getVSubBlock(n7, 1);
                            for (n4 = 0; n4 < 4; ++n4) {
                                n5 += subBlock2.getDest()[n4][3];
                                n6 += subBlock.getDest()[n4][3];
                            }
                        }
                    }
                    if (bl2) {
                        for (n7 = 0; n7 < 2; ++n7) {
                            subBlock2 = macroBlock2.getUSubBlock(1, n7);
                            subBlock = macroBlock2.getVSubBlock(1, n7);
                            for (n4 = 0; n4 < 4; ++n4) {
                                n5 += subBlock2.getDest()[3][n4];
                                n6 += subBlock.getDest()[3][n4];
                            }
                        }
                    }
                    n7 = 2;
                    if (bl) {
                        ++n7;
                    }
                    if (bl2) {
                        ++n7;
                    }
                    n3 = n5 + (1 << n7 - 1) >> n7;
                    n2 = n6 + (1 << n7 - 1) >> n7;
                } else {
                    n3 = 128;
                    n2 = 128;
                }
                int[][] nArray = new int[4][4];
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        nArray[j][i] = n3;
                    }
                }
                int[][] nArray2 = new int[4][4];
                for (n = 0; n < 4; ++n) {
                    for (n4 = 0; n4 < 4; ++n4) {
                        nArray2[n4][n] = n2;
                    }
                }
                for (n = 0; n < 2; ++n) {
                    for (n4 = 0; n4 < 2; ++n4) {
                        SubBlock subBlock = this.uSubBlocks[n4][n];
                        SubBlock subBlock3 = this.vSubBlocks[n4][n];
                        subBlock.setPredict(nArray);
                        subBlock3.setPredict(nArray2);
                    }
                }
                break;
            }
            case 1: {
                int n;
                SubBlock[] subBlockArray = new SubBlock[2];
                SubBlock[] subBlockArray2 = new SubBlock[2];
                for (n = 0; n < 2; ++n) {
                    subBlockArray[n] = macroBlock.getUSubBlock(n, 1);
                    subBlockArray2[n] = macroBlock.getVSubBlock(n, 1);
                }
                for (n = 0; n < 2; ++n) {
                    for (int i = 0; i < 2; ++i) {
                        SubBlock subBlock = this.uSubBlocks[n][i];
                        SubBlock subBlock4 = this.vSubBlocks[n][i];
                        int[][] nArray = new int[4][4];
                        int[][] nArray3 = new int[4][4];
                        for (int j = 0; j < 4; ++j) {
                            for (int k = 0; k < 4; ++k) {
                                nArray[j][k] = subBlockArray[n].getMacroBlockPredict(1)[j][3];
                                nArray3[j][k] = subBlockArray2[n].getMacroBlockPredict(1)[j][3];
                            }
                        }
                        subBlock.setPredict(nArray);
                        subBlock4.setPredict(nArray3);
                    }
                }
                break;
            }
            case 2: {
                int n;
                SubBlock[] subBlockArray = new SubBlock[2];
                SubBlock[] subBlockArray3 = new SubBlock[2];
                for (n = 0; n < 2; ++n) {
                    subBlockArray[n] = macroBlock2.getUSubBlock(1, n);
                    subBlockArray3[n] = macroBlock2.getVSubBlock(1, n);
                }
                for (n = 0; n < 2; ++n) {
                    for (int i = 0; i < 2; ++i) {
                        SubBlock subBlock = this.uSubBlocks[i][n];
                        SubBlock subBlock5 = this.vSubBlocks[i][n];
                        int[][] nArray = new int[4][4];
                        int[][] nArray4 = new int[4][4];
                        for (int j = 0; j < 4; ++j) {
                            for (int k = 0; k < 4; ++k) {
                                nArray[k][j] = subBlockArray[n].getMacroBlockPredict(2)[3][j];
                                nArray4[k][j] = subBlockArray3[n].getMacroBlockPredict(2)[3][j];
                            }
                        }
                        subBlock.setPredict(nArray);
                        subBlock5.setPredict(nArray4);
                    }
                }
                break;
            }
            case 3: {
                int n;
                MacroBlock macroBlock3 = frame.getMacroBlock(this.x - 1, this.y - 1);
                SubBlock subBlock = macroBlock3.getUSubBlock(1, 1);
                int n8 = subBlock.getDest()[3][3];
                SubBlock subBlock6 = macroBlock3.getVSubBlock(1, 1);
                int n9 = subBlock6.getDest()[3][3];
                SubBlock[] subBlockArray = new SubBlock[2];
                SubBlock[] subBlockArray4 = new SubBlock[2];
                SubBlock[] subBlockArray5 = new SubBlock[2];
                SubBlock[] subBlockArray6 = new SubBlock[2];
                for (n = 0; n < 2; ++n) {
                    subBlockArray[n] = macroBlock.getUSubBlock(n, 1);
                    subBlockArray4[n] = macroBlock2.getUSubBlock(1, n);
                    subBlockArray5[n] = macroBlock.getVSubBlock(n, 1);
                    subBlockArray6[n] = macroBlock2.getVSubBlock(1, n);
                }
                for (n = 0; n < 2; ++n) {
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 2; ++j) {
                            for (int k = 0; k < 4; ++k) {
                                int n10 = subBlockArray4[n].getDest()[3][i] + subBlockArray[j].getDest()[k][3] - n8;
                                n10 = MacroBlock.squeeze(n10, 255);
                                this.uSubBlocks[j][n].setPixel(k, i, n10);
                                int n11 = subBlockArray6[n].getDest()[3][i] + subBlockArray5[j].getDest()[k][3] - n9;
                                n11 = MacroBlock.squeeze(n11, 255);
                                this.vSubBlocks[j][n].setPixel(k, i, n11);
                            }
                        }
                    }
                }
                break;
            }
        }
    }

    public void predictY(Frame frame) {
        MacroBlock macroBlock = frame.getMacroBlock(this.x, this.y - 1);
        MacroBlock macroBlock2 = frame.getMacroBlock(this.x - 1, this.y);
        switch (this.yMode) {
            case 0: {
                int n;
                int n2;
                int n3;
                boolean bl = false;
                boolean bl2 = false;
                int n4 = 0;
                if (this.x > 0) {
                    bl2 = true;
                }
                if (this.y > 0) {
                    bl = true;
                }
                if (bl || bl2) {
                    SubBlock subBlock;
                    int n5;
                    if (bl) {
                        for (n5 = 0; n5 < 4; ++n5) {
                            subBlock = macroBlock.getYSubBlock(n5, 3);
                            for (n3 = 0; n3 < 4; ++n3) {
                                n4 += subBlock.getDest()[n3][3];
                            }
                        }
                    }
                    if (bl2) {
                        for (n5 = 0; n5 < 4; ++n5) {
                            subBlock = macroBlock2.getYSubBlock(3, n5);
                            for (n3 = 0; n3 < 4; ++n3) {
                                n4 += subBlock.getDest()[3][n3];
                            }
                        }
                    }
                    n5 = 3;
                    if (bl) {
                        ++n5;
                    }
                    if (bl2) {
                        ++n5;
                    }
                    n2 = n4 + (1 << n5 - 1) >> n5;
                } else {
                    n2 = 128;
                }
                int[][] nArray = new int[4][4];
                for (n = 0; n < 4; ++n) {
                    for (n3 = 0; n3 < 4; ++n3) {
                        nArray[n3][n] = n2;
                    }
                }
                for (n = 0; n < 4; ++n) {
                    for (n3 = 0; n3 < 4; ++n3) {
                        SubBlock subBlock = this.ySubBlocks[n3][n];
                        subBlock.setPredict(nArray);
                    }
                }
                break;
            }
            case 1: {
                int n;
                SubBlock[] subBlockArray = new SubBlock[4];
                for (n = 0; n < 4; ++n) {
                    subBlockArray[n] = macroBlock.getYSubBlock(n, 3);
                }
                for (n = 0; n < 4; ++n) {
                    for (int i = 0; i < 4; ++i) {
                        SubBlock subBlock = this.ySubBlocks[i][n];
                        int[][] nArray = new int[4][4];
                        for (int j = 0; j < 4; ++j) {
                            for (int k = 0; k < 4; ++k) {
                                nArray[k][j] = subBlockArray[i].getPredict(2, false)[k][3];
                            }
                        }
                        subBlock.setPredict(nArray);
                    }
                }
                break;
            }
            case 2: {
                int n;
                int n6;
                SubBlock[] subBlockArray = new SubBlock[4];
                for (n6 = 0; n6 < 4; ++n6) {
                    subBlockArray[n6] = macroBlock2.getYSubBlock(3, n6);
                }
                for (n6 = 0; n6 < 4; ++n6) {
                    for (n = 0; n < 4; ++n) {
                        SubBlock subBlock = this.ySubBlocks[n][n6];
                        int[][] nArray = new int[4][4];
                        for (int i = 0; i < 4; ++i) {
                            for (int j = 0; j < 4; ++j) {
                                nArray[j][i] = subBlockArray[n6].getPredict(0, true)[3][i];
                            }
                        }
                        subBlock.setPredict(nArray);
                    }
                }
                SubBlock[] subBlockArray2 = new SubBlock[2];
                for (n = 0; n < 2; ++n) {
                    subBlockArray2[n] = macroBlock2.getYSubBlock(1, n);
                }
                break;
            }
            case 3: {
                int n;
                MacroBlock macroBlock3 = frame.getMacroBlock(this.x - 1, this.y - 1);
                SubBlock subBlock = macroBlock3.getYSubBlock(3, 3);
                int n7 = subBlock.getDest()[3][3];
                SubBlock[] subBlockArray = new SubBlock[4];
                SubBlock[] subBlockArray3 = new SubBlock[4];
                for (n = 0; n < 4; ++n) {
                    subBlockArray[n] = macroBlock.getYSubBlock(n, 3);
                }
                for (n = 0; n < 4; ++n) {
                    subBlockArray3[n] = macroBlock2.getYSubBlock(3, n);
                }
                for (n = 0; n < 4; ++n) {
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            for (int k = 0; k < 4; ++k) {
                                int n8 = subBlockArray3[n].getDest()[3][i] + subBlockArray[j].getDest()[k][3] - n7;
                                this.ySubBlocks[j][n].setPixel(k, i, MacroBlock.squeeze(n8, 255));
                            }
                        }
                    }
                }
                break;
            }
        }
    }

    public void recon_mb() {
        SubBlock subBlock;
        int n;
        int n2;
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                subBlock = this.ySubBlocks[n][n2];
                subBlock.reconstruct();
            }
        }
        for (n2 = 0; n2 < 2; ++n2) {
            for (n = 0; n < 2; ++n) {
                subBlock = this.uSubBlocks[n][n2];
                subBlock.reconstruct();
            }
        }
        for (n2 = 0; n2 < 2; ++n2) {
            for (n = 0; n < 2; ++n) {
                subBlock = this.vSubBlocks[n][n2];
                subBlock.reconstruct();
            }
        }
    }

    public void setFilterLevel(int n) {
        this.filterLevel = n;
    }

    public void setSkipCoeff(int n) {
        this.skipCoeff = n;
    }

    public void setUVFilterLevel(int n) {
        this.uVFilterLevel = n;
    }

    public void setUvMode(int n) {
        this.uvMode = n;
    }

    public void setYMode(int n) {
        this.yMode = n;
    }

    private static int squeeze(int n, int n2) {
        int n3 = n;
        if (n3 > n2) {
            n3 = n2;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }
}

