/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.common;

import com.sun.medialib.codec.jiio.Util;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PackageUtil {
    private static boolean isCodecLibAvailable = false;
    private static final String version;
    private static final String vendor;
    private static final String specTitle;

    static {
        try {
            isCodecLibAvailable = Util.isCodecLibAvailable();
        }
        catch (Throwable e) {
            isCodecLibAvailable = false;
        }
        Package thisPackage = null;
        try {
            Class<?> thisClass = Class.forName("com.sun.media.imageioimpl.common.PackageUtil");
            thisPackage = thisClass.getPackage();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (thisPackage != null) {
            version = thisPackage.getImplementationVersion() == null ? "1.1" : thisPackage.getImplementationVersion();
            vendor = thisPackage.getImplementationVendor() == null ? "Sun Microsystems, Inc." : thisPackage.getImplementationVendor();
            specTitle = thisPackage.getSpecificationTitle() == null ? "Java Advanced Imaging Image I/O Tools" : thisPackage.getSpecificationTitle();
        } else {
            version = "1.1";
            vendor = "Sun Microsystems, Inc.";
            specTitle = "Java Advanced Imaging Image I/O Tools";
        }
    }

    public static final boolean isCodecLibAvailable() {
        Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String property = null;
                try {
                    property = System.getProperty("com.sun.media.imageio.disableCodecLib");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return property != null && property.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        boolean isCodecLibDisabled = result;
        return isCodecLibAvailable && !isCodecLibDisabled;
    }

    public static final String getVersion() {
        return version;
    }

    public static final String getVendor() {
        return vendor;
    }

    public static final String getSpecificationTitle() {
        return specTitle;
    }
}

