/*
 * Decompiled with CFR 0.152.
 */
package SK.gnome.capabilities;

import SK.gnome.capabilities.sane.SaneActivity;
import SK.gnome.capabilities.twain.TwainActivity;
import SK.gnome.morena.MorenaConstants;
import SK.gnome.morena.MorenaSource;
import SK.gnome.sane.SaneConnection;
import SK.gnome.twain.TwainException;
import SK.gnome.twain.TwainManager;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MorenaCapabilities
implements MorenaConstants {
    static final String TWAIN_ = "TWAIN_";
    static final String SANE_ = "SANE_";
    static Properties properties;
    static String selectedSource;
    private TwainActivity twainActivity = null;
    private SaneActivity saneActivity = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void selectSource(JPanel centerPanel) {
        String host = "localhost";
        int port = 6566;
        String userName = "";
        boolean TWAIN = false;
        boolean SANE = true;
        Object[] INTERFACE = new String[]{"TWAIN", "SANE", MORENA_MESSAGES.getString("CANCEL")};
        String os = System.getProperty("os.name").toLowerCase();
        int api = 1;
        if (os.indexOf("windows") >= 0 || os.indexOf("os x") >= 0) {
            api = JOptionPane.showOptionDialog(centerPanel, MORENA_MESSAGES.getString("SELECT_API"), MORENA_MESSAGES.getString("SOURCE_SELECTOR_TITLE"), -1, 3, null, INTERFACE, INTERFACE[0]);
        }
        String sourceName = null;
        MorenaSource source = null;
        switch (api) {
            case 0: {
                source = TwainManager.selectSource(centerPanel, null);
                if (null != source) {
                    sourceName = TWAIN_ + source.toString();
                }
                try {
                    TwainManager.close();
                }
                catch (TwainException e2) {
                    e2.printStackTrace();
                }
                break;
            }
            case 1: {
                class SaneConnectionOptionPane
                extends JPanel {
                    private JTextField hostTextField;
                    private JTextField portTextField;
                    private JTextField userNameTextField;

                    public SaneConnectionOptionPane(Component centerPanel, String host, int port, String userName) {
                        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                        this.setLayout(new BoxLayout(this, 1));
                        this.setAlignmentX(0.0f);
                        JPanel hostPanel = new JPanel();
                        hostPanel.setLayout(new BoxLayout(hostPanel, 0));
                        hostPanel.setAlignmentX(0.0f);
                        hostPanel.add(new JLabel(MorenaConstants.MORENA_MESSAGES.getString("HOST") + ": "));
                        this.hostTextField = new JTextField(host);
                        hostPanel.add(this.hostTextField);
                        this.add(hostPanel);
                        JPanel portPanel = new JPanel();
                        portPanel.setLayout(new BoxLayout(portPanel, 0));
                        portPanel.setAlignmentX(0.0f);
                        portPanel.add(new JLabel(MorenaConstants.MORENA_MESSAGES.getString("PORT") + ": "));
                        this.portTextField = new JTextField(String.valueOf(port));
                        portPanel.add(this.portTextField);
                        this.add(portPanel);
                        JPanel userNamePanel = new JPanel();
                        userNamePanel.setLayout(new BoxLayout(userNamePanel, 0));
                        userNamePanel.setAlignmentX(0.0f);
                        userNamePanel.add(new JLabel(MorenaConstants.MORENA_MESSAGES.getString("USER_NAME") + ": "));
                        this.userNameTextField = new JTextField(userName, 10);
                        userNamePanel.add(this.userNameTextField);
                        this.add(userNamePanel);
                    }

                    public String getHost() {
                        return this.hostTextField.getText();
                    }

                    public int getPort() {
                        return Integer.parseInt(this.portTextField.getText());
                    }

                    public String getUserName() {
                        return this.userNameTextField.getText();
                    }
                }
                SaneConnectionOptionPane saneConnectionOptionPane = new SaneConnectionOptionPane(centerPanel, host, port, userName);
                int answer = JOptionPane.showConfirmDialog(centerPanel, saneConnectionOptionPane, MORENA_MESSAGES.getString("ENTER_SANE_HOST"), 2);
                if (0 != answer) break;
                host = saneConnectionOptionPane.getHost();
                port = saneConnectionOptionPane.getPort();
                userName = saneConnectionOptionPane.getUserName();
                SaneConnection sc = null;
                Cursor previousCursor = centerPanel.getCursor();
                try {
                    centerPanel.setCursor(Cursor.getPredefinedCursor(3));
                    sc = SaneConnection.connect(host, port, userName);
                }
                catch (Exception e1) {
                    System.out.println("SelectSource: " + e1.getMessage());
                }
                finally {
                    centerPanel.setCursor(previousCursor);
                }
                source = sc.selectSource(centerPanel, null);
                if (null != source) {
                    sourceName = SANE_ + source.toString() + ";" + host + ";" + port + ";" + userName;
                }
                try {
                    sc.close();
                    break;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (null != sourceName) {
            try {
                properties = new Properties();
                properties.setProperty("selectedSource", sourceName);
                File file = new File(System.getProperty("user.home") + "/.morena/" + "MorenaCapabilities.properties");
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                }
                properties.store(new FileOutputStream(file), null);
                selectedSource = sourceName;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(centerPanel, ex.getMessage(), MORENA_MESSAGES.getString("EXCEPTION_STORE_PROPERTIES"), 0);
                ex.printStackTrace();
            }
        }
    }

    public MorenaCapabilities(JPanel centerPanel) throws Exception {
        try {
            properties = new Properties();
            properties.load(new FileInputStream(System.getProperty("user.home") + "/.morena/" + "MorenaCapabilities.properties"));
            selectedSource = properties.getProperty("selectedSource", "");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(centerPanel, e.getMessage(), MORENA_MESSAGES.getString("EXCEPTION_LOAD_PROPERTIES"), 0);
            e.printStackTrace();
        }
        String sourceName = null;
        if (selectedSource.startsWith(TWAIN_)) {
            sourceName = selectedSource.substring(TWAIN_.length());
            this.twainActivity = new TwainActivity(centerPanel, sourceName);
        } else if (selectedSource.startsWith(SANE_)) {
            sourceName = selectedSource.substring(SANE_.length());
            this.saneActivity = new SaneActivity(centerPanel, sourceName);
        } else {
            JOptionPane.showMessageDialog(centerPanel, MORENA_MESSAGES.getString("EXCEPTION_EXPECTED_SOURCE") + ":" + sourceName, "", 0);
        }
    }

    public int showDialogWindow() {
        if (null != this.twainActivity) {
            return this.twainActivity.showDialogWindow();
        }
        if (null != this.saneActivity) {
            return this.saneActivity.showDialogWindow();
        }
        return 0;
    }

    public MorenaSource getSource() {
        if (null != this.twainActivity) {
            return this.twainActivity.getSource();
        }
        if (null != this.saneActivity) {
            return this.saneActivity.getSource();
        }
        return null;
    }

    public void close() {
        if (null != this.twainActivity) {
            this.twainActivity.close();
        } else if (null != this.saneActivity) {
            this.saneActivity.close();
        }
    }

    static {
        selectedSource = "";
    }
}

