/*
 * Decompiled with CFR 0.152.
 */
package SK.gnome.capabilities.sane;

import SK.gnome.capabilities.Capabilities;
import SK.gnome.capabilities.Capability;
import SK.gnome.capabilities.CapabilityDialog;
import SK.gnome.capabilities.sane.SaneCapability;
import SK.gnome.capabilities.sane.SaneSelectOptionsDialog;
import SK.gnome.morena.MorenaImage;
import SK.gnome.sane.SaneConnection;
import SK.gnome.sane.SaneException;
import SK.gnome.sane.SaneOptionDescriptor;
import SK.gnome.sane.SaneSource;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SaneActivity
extends Capabilities {
    private String host;
    private int port;
    private String userName;
    private SaneConnection sc;
    private SaneSource source;

    public SaneActivity(Component centerPanel, String sourceDescription) {
        Cursor previousCursor;
        block7: {
            this.host = "localhost";
            this.port = 6566;
            this.userName = "";
            this.sc = null;
            this.centerPanel = centerPanel;
            previousCursor = SwingUtilities.windowForComponent(centerPanel).getCursor();
            SwingUtilities.windowForComponent(centerPanel).setCursor(Cursor.getPredefinedCursor(3));
            int separator1 = sourceDescription.indexOf(59);
            this.sourceName = sourceDescription.substring(0, separator1);
            int separator2 = sourceDescription.indexOf(59, separator1 + 1);
            this.host = sourceDescription.substring(separator1 + 1, separator2);
            int separator3 = sourceDescription.indexOf(59, separator2 + 1);
            this.port = Integer.parseInt(sourceDescription.substring(separator2 + 1, separator3));
            this.userName = sourceDescription.substring(separator3 + 1);
            this.openSaneSource(this.sourceName, this.host, this.port, this.userName);
            if (null != this.source) {
                block6: {
                    this.allCapabilities = new ArrayList();
                    this.properties = new Properties();
                    this.sourceValidFileName = "SANE_" + this.makeFileNameValid(this.getSource().toString()) + ".properties";
                    try {
                        this.properties.load(new FileInputStream(System.getProperty("user.home") + "/.morena/" + this.sourceValidFileName));
                    }
                    catch (Exception e) {
                        if (!Capabilities.debug) break block6;
                        System.out.println("SaneActivity.SaneActivity()" + e.getMessage() + " caused by " + e.getCause());
                    }
                }
                try {
                    SaneOptionDescriptor[] descriptor = this.getSource().getOptionDescriptors();
                    for (int i = 1; i < descriptor.length; ++i) {
                        SaneOptionDescriptor option = descriptor[i];
                        this.allCapabilities.add(new SaneCapability(this, option, this.properties));
                    }
                }
                catch (Exception e) {
                    if (!Capabilities.debug) break block7;
                    System.out.println("SaneActivity.SaneActivity()" + e.getMessage() + " caused by " + e.getCause());
                }
            }
        }
        this.restartAfterPreview = Boolean.parseBoolean(this.properties.getProperty("restartAfterPreview", "true"));
        this.sleepTimeBeforeRestart = Integer.parseInt(this.properties.getProperty("sleepTimeBeforeRestart", "3000"));
        SwingUtilities.windowForComponent(centerPanel).setCursor(previousCursor);
    }

    private void openSaneSource(String sourceName, String host, int port, String userName) {
        try {
            this.sc = SaneConnection.connect(host, port, userName);
        }
        catch (SaneException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SaneSource[] sourceArray = this.sc.listSources();
        if (null == sourceArray) {
            JOptionPane.showMessageDialog(this.centerPanel, "Empty list of Sane sources.");
        }
        if (sourceArray != null) {
            this.source = null;
            for (int i = 0; i < sourceArray.length; ++i) {
                SaneSource temp = sourceArray[i];
                if (!temp.toString().equals(sourceName)) continue;
                this.source = temp;
                break;
            }
        }
        if (null == this.source) {
            JOptionPane.showMessageDialog(this.centerPanel, "No Sane source.");
        }
    }

    private void openSaneSource() {
        this.openSaneSource(this.sourceName, this.host, this.port, this.userName);
    }

    public int showDialogWindow() {
        block5: {
            boolean previousUnsupportedCapabilityException;
            boolean previousBadValueExceptionMask;
            block4: {
                previousBadValueExceptionMask = true;
                previousUnsupportedCapabilityException = true;
                try {
                    previousBadValueExceptionMask = this.getSource().maskBadValueException(false);
                    previousUnsupportedCapabilityException = this.getSource().maskUnsupportedCapabilityException(false);
                }
                catch (Exception e) {
                    if (!Capabilities.debug) break block4;
                    System.out.println("SaneActivity.showDialogWindow()" + e.getMessage() + " caused by " + e.getCause());
                }
            }
            this.frame = JOptionPane.getFrameForComponent(this.centerPanel);
            this.dialogWindow = new CapabilityDialog(this.frame, this);
            this.dialogWindow.setVisible(true);
            try {
                this.getSource().maskBadValueException(previousBadValueExceptionMask);
                this.getSource().maskUnsupportedCapabilityException(previousUnsupportedCapabilityException);
            }
            catch (Exception e) {
                if (!Capabilities.debug) break block5;
                System.out.println("SaneActivity.showDialogWindow()" + e.getMessage() + " caused by " + e.getCause());
            }
        }
        return this.dialogWindow.getReturnValue();
    }

    public SaneConnection getSaneConnection() {
        return this.sc;
    }

    public SaneSource getSource() {
        return this.source;
    }

    public void close() {
        if (null != this.sc) {
            try {
                this.sc.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public MorenaImage getPreviewImage() {
        String name;
        Object resolution = null;
        this.properties.clear();
        for (Capability capability : this.getCapabilities()) {
            name = capability.getName();
            if (null == name) continue;
            try {
                if (capability.isSelected()) {
                    Object[] supported;
                    this.properties.put(name, String.valueOf(capability.getValue()));
                    if (name.equals("tl-x")) {
                        capability.setValue("0");
                    } else if (name.equals("tl-y")) {
                        capability.setValue("0");
                    } else if (name.equals("br-x")) {
                        supported = capability.getSupportedValues();
                        double maxWidth = Double.parseDouble((String)supported[supported.length - 1]);
                        capability.setValue(String.valueOf(maxWidth));
                    } else if (name.equals("br-y")) {
                        supported = capability.getSupportedValues();
                        double maxHeight = Double.parseDouble((String)supported[supported.length - 1]);
                        capability.setValue(String.valueOf(maxHeight));
                    }
                }
                if (name.equals("preview")) {
                    capability.setValue("true");
                    continue;
                }
                if (!name.equals("resolution")) continue;
                resolution = capability.getValue();
                capability.setValue("96");
            }
            catch (Exception e) {
                if (!Capabilities.debug) continue;
                System.out.println("SaneActivity.getPreviewImage()" + e.getMessage() + " caused by " + e.getCause());
            }
        }
        MorenaImage morenaImage = new MorenaImage(this.getSource());
        if (this.restartAfterPreview) {
            block24: {
                this.close();
                try {
                    Thread.sleep(this.sleepTimeBeforeRestart);
                }
                catch (InterruptedException e) {
                    if (!Capabilities.debug) break block24;
                    System.out.println("SaneActivity.getPreviewImage()" + e.getMessage() + " caused by " + e.getCause());
                }
            }
            this.openSaneSource();
        }
        for (Capability capability : this.allCapabilities) {
            block25: {
                name = capability.getName();
                if (null == name) continue;
                if (capability.isSelected() && capability.isSetMethodSupported()) {
                    try {
                        capability.setValue(this.properties.getProperty(name));
                    }
                    catch (Exception e) {
                        if (!Capabilities.debug) break block25;
                        System.out.println("SaneActivity.getPreviewImage()" + e.getMessage() + " caused by " + e.getCause());
                    }
                }
            }
            if (name.equals("preview")) {
                try {
                    capability.setValue("false");
                }
                catch (Exception e) {
                    if (!Capabilities.debug) continue;
                    System.out.println("SaneActivity.getPreviewImage()" + e.getMessage() + " caused by " + e.getCause());
                }
                continue;
            }
            if (!name.equals("resolution")) continue;
            try {
                capability.setValue(String.valueOf(resolution));
            }
            catch (Exception e) {
                if (!Capabilities.debug) continue;
                System.out.println("SaneActivity.getPreviewImage()" + e.getMessage() + " caused by " + e.getCause());
            }
        }
        return morenaImage;
    }

    public String getSourceName() {
        try {
            return this.getSource().getName();
        }
        catch (SaneException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("selectCapabilitiesButton")) {
            new SaneSelectOptionsDialog(this.frame, this, this.dialogWindow);
        }
    }
}

