/*
 * Decompiled with CFR 0.152.
 */
package SK.gnome.capabilities.sane;

import SK.gnome.capabilities.Capabilities;
import SK.gnome.capabilities.Capability;
import SK.gnome.capabilities.sane.SaneActivity;
import SK.gnome.morena.MorenaOptionsDescriptor;
import SK.gnome.sane.SaneOptionDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class SaneCapability
extends Capability {
    protected SaneActivity saneActivity;
    private SaneOptionDescriptor optionDescriptor;

    public SaneCapability(SaneActivity saneActivity, SaneOptionDescriptor optionDescriptor, Properties properties) {
        this.saneActivity = saneActivity;
        this.optionDescriptor = optionDescriptor;
        this.name = optionDescriptor.name;
        this.title = optionDescriptor.title;
        if (null != this.name && properties.containsKey(this.name)) {
            block3: {
                String value = properties.getProperty(this.name);
                try {
                    this.setValue(value);
                }
                catch (Exception e) {
                    if (!Capabilities.debug) break block3;
                    System.out.println("SaneCapability.SaneCapability().setValue(" + value + ") failed: " + e.getMessage() + " caused by " + e.getCause());
                }
            }
            this.selected = true;
        }
    }

    public Object[] getSupportedValues() {
        Object[] supportedValues = null;
        if (null != this.optionDescriptor.constraint) {
            if (String[].class.isInstance(this.optionDescriptor.constraint)) {
                supportedValues = (String[])this.optionDescriptor.constraint;
            } else if (int[].class.isInstance(this.optionDescriptor.constraint)) {
                int[] v = (int[])this.optionDescriptor.constraint;
                supportedValues = new String[v.length];
                for (int j = 0; j < v.length; ++j) {
                    supportedValues[j] = this.optionDescriptor.type == 2 ? String.valueOf((double)v[j] / 65536.0) : String.valueOf(v[j]);
                }
            } else if (MorenaOptionsDescriptor.IntRange.class.isInstance(this.optionDescriptor.constraint)) {
                MorenaOptionsDescriptor.IntRange intRange = (MorenaOptionsDescriptor.IntRange)this.optionDescriptor.constraint;
                int min = intRange.min;
                int max = intRange.max;
                int quant = intRange.quant;
                if ((double)quant < 0.01) {
                    quant = (int)this.computeQuant(min, max);
                }
                Vector<String> v = new Vector<String>();
                int j = 0;
                int value = min;
                while (value <= max) {
                    v.add(String.valueOf(value));
                    value = ++j * quant + min;
                }
                supportedValues = v.toArray();
            } else if (MorenaOptionsDescriptor.DoubleRange.class.isInstance(this.optionDescriptor.constraint)) {
                MorenaOptionsDescriptor.DoubleRange doubleRange = (MorenaOptionsDescriptor.DoubleRange)this.optionDescriptor.constraint;
                double min = doubleRange.min;
                double max = doubleRange.max;
                double quant = doubleRange.quant;
                if (quant < 0.01) {
                    quant = this.computeQuant(min, max);
                }
                Vector<String> v = new Vector<String>();
                int j = 0;
                double value = min;
                while (value <= max) {
                    v.add(String.valueOf(value));
                    value = (double)(++j) * quant + min;
                }
                supportedValues = v.toArray();
            }
        }
        return supportedValues;
    }

    public Object getValue() {
        try {
            return this.saneActivity.getSource().getOption(this.name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isSetMethodSupported() {
        return true;
    }

    public boolean isSupported() {
        return true;
    }

    public void setValue(String value) throws Exception {
        if (Capabilities.debug) {
            System.out.println("SaneCapability.setValue()." + this.name + "=" + value);
        }
        try {
            switch (this.optionDescriptor.type) {
                case 0: {
                    this.saneActivity.getSource().setOption(this.name, (Object)Boolean.valueOf(value));
                    break;
                }
                case 1: {
                    this.saneActivity.getSource().setOption(this.name, (Object)Integer.valueOf(value));
                    break;
                }
                case 2: {
                    this.saneActivity.getSource().setOption(this.name, (Object)Double.valueOf(value));
                    break;
                }
                case 3: {
                    this.saneActivity.getSource().setOption(this.name, (Object)value);
                    break;
                }
            }
            if (Capabilities.debug) {
                System.out.println("SaneCapability.setValue()." + this.name + ".getOption()=" + this.saneActivity.getSource().getOption(this.name));
            }
            Enumeration e2 = this.listeners.elements();
            while (e2.hasMoreElements()) {
                ((PropertyChangeListener)e2.nextElement()).propertyChange(new PropertyChangeEvent(this, null, null, null));
            }
        }
        catch (Exception e) {
            Enumeration e2 = this.listeners.elements();
            while (e2.hasMoreElements()) {
                ((PropertyChangeListener)e2.nextElement()).propertyChange(new PropertyChangeEvent(this, null, null, null));
            }
            throw e;
        }
    }

    public int getType() {
        return this.optionDescriptor.type;
    }

    public int getCap() {
        return this.optionDescriptor.cap;
    }

    public String getTitle() {
        return this.optionDescriptor.title;
    }
}

